/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.jfree.layouting.input.style.CSSStyleRule;
import org.jfree.layouting.input.style.keys.box.BoxStyleKeys;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.util.AttributeMap;
import org.jfree.layouting.util.LocaleUtility;
import org.jfree.report.expressions.Expression;
import org.jfree.report.structure.Node;

public abstract class Element
extends Node {
    private static final Expression[] EMPTY_EXPRESSIONS = new Expression[0];
    private static final String[] EMPTY_STRINGS = new String[0];
    private static final Map EMPTY_MAP = Collections.unmodifiableMap(new HashMap());
    public static final String NAME_ATTRIBUTE = "name";
    public static final String ID_ATTRIBUTE = "id";
    public static final String TYPE_ATTRIBUTE = "type";
    public static final String NAMESPACE_ATTRIBUTE = "namespace";
    public static final String VIRTUAL_ATTRIBUTE = "virtual";
    private AttributeMap attributes;
    private CSSStyleRule style = new CSSStyleRule(null, null);
    private ArrayList expressions;
    private AttributeMap attributeExpressions;
    private HashMap styleExpressions;
    private boolean enabled = true;
    private boolean virtual;
    private Expression displayCondition;

    protected Element() {
        this.attributes = new AttributeMap();
        this.setNamespace("http://jfreereport.sourceforge.net/namespaces/engine");
    }

    public String getNamespace() {
        return (String)this.getAttribute("http://jfreereport.sourceforge.net/namespaces/engine", NAMESPACE_ATTRIBUTE);
    }

    public void setNamespace(String id) {
        this.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", NAMESPACE_ATTRIBUTE, id);
    }

    public String getId() {
        return (String)this.getAttribute("http://www.w3.org/XML/1998/namespace", ID_ATTRIBUTE);
    }

    public void setId(String id) {
        this.setAttribute("http://www.w3.org/XML/1998/namespace", ID_ATTRIBUTE, id);
    }

    public String getType() {
        return (String)this.getAttribute("http://jfreereport.sourceforge.net/namespaces/engine", TYPE_ATTRIBUTE);
    }

    public void setType(String type) {
        this.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", TYPE_ATTRIBUTE, type);
    }

    public void setName(String name) {
        this.setAttribute("http://www.w3.org/XML/1998/namespace", NAME_ATTRIBUTE, name);
    }

    public String getName() {
        return (String)this.getAttribute("http://www.w3.org/XML/1998/namespace", NAME_ATTRIBUTE);
    }

    public void setAttribute(String name, Object value) {
        this.setAttribute(this.getNamespace(), name, value);
    }

    public void setAttribute(String namespace, String name, Object value) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (this.attributes == null) {
            this.attributes = new AttributeMap();
        }
        this.attributes.setAttribute(namespace, name, value);
    }

    public Object getAttribute(String name) {
        return this.getAttribute(this.getNamespace(), name);
    }

    public Object getAttribute(String namespace, String name) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.getAttribute(namespace, name);
    }

    public Map getAttributes(String namespace) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.getAttributes(namespace);
    }

    public AttributeMap getAttributeMap() {
        return new AttributeMap(this.attributes);
    }

    public String[] getAttributeNameSpaces() {
        if (this.attributes == null) {
            return EMPTY_STRINGS;
        }
        return this.attributes.getNameSpaces();
    }

    public CSSStyleRule getStyle() {
        return this.style;
    }

    public void setVisibility(CSSConstant v) {
        this.getStyle().setPropertyValue(BoxStyleKeys.VISIBILITY, (CSSValue)v);
    }

    public CSSConstant getVisibility() {
        return (CSSConstant)this.getStyle().getPropertyCSSValue(BoxStyleKeys.VISIBILITY);
    }

    public void setAttributeExpression(String attr, Expression function) {
        this.setAttribute(this.getNamespace(), attr, function);
    }

    public void setAttributeExpression(String namespace, String attr, Expression function) {
        if (this.attributeExpressions == null) {
            if (function == null) {
                return;
            }
            this.attributeExpressions = new AttributeMap();
        }
        this.attributeExpressions.setAttribute(namespace, attr, (Object)function);
    }

    public Expression getAttributeExpression(String attr) {
        return this.getAttributeExpression(this.getNamespace(), attr);
    }

    public Expression getAttributeExpression(String namespace, String attr) {
        if (this.attributeExpressions == null) {
            return null;
        }
        return (Expression)this.attributeExpressions.getAttribute(namespace, attr);
    }

    public Map getAttributeExpressions(String namespace) {
        if (this.attributeExpressions == null) {
            return null;
        }
        return this.attributeExpressions.getAttributes(namespace);
    }

    public AttributeMap getAttributeExpressionMap() {
        if (this.attributeExpressions == null) {
            return new AttributeMap();
        }
        return new AttributeMap(this.attributeExpressions);
    }

    public void setStyleExpression(String property, Expression function) {
        if (function == null) {
            if (this.styleExpressions != null) {
                this.styleExpressions.remove(property);
            }
        } else {
            if (this.styleExpressions == null) {
                this.styleExpressions = new HashMap();
            }
            this.styleExpressions.put(property, function);
        }
    }

    public Expression getStyleExpression(String property) {
        if (this.styleExpressions == null) {
            return null;
        }
        return (Expression)this.styleExpressions.get(property);
    }

    public Map getStyleExpressions() {
        if (this.styleExpressions == null) {
            return EMPTY_MAP;
        }
        return Collections.unmodifiableMap(this.styleExpressions);
    }

    public void addExpression(Expression function) {
        if (this.expressions == null) {
            this.expressions = new ArrayList();
        }
        this.expressions.add(function);
    }

    public Expression[] getExpressions() {
        if (this.expressions == null) {
            return EMPTY_EXPRESSIONS;
        }
        return this.expressions.toArray(new Expression[this.expressions.size()]);
    }

    public void setExpressions(Expression[] expressions) {
        if (expressions == null) {
            throw new NullPointerException("JFreeReport.setExpressions(...) : null not permitted.");
        }
        if (this.expressions == null) {
            this.expressions = new ArrayList(expressions.length);
        } else {
            this.expressions.clear();
        }
        this.expressions.addAll(Arrays.asList(expressions));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Expression getDisplayCondition() {
        return this.displayCondition;
    }

    public void setDisplayCondition(Expression displayCondition) {
        this.displayCondition = displayCondition;
    }

    public Locale getLocale() {
        Locale locale = this.getLocaleFromAttributes();
        if (locale != null) {
            return locale;
        }
        return super.getLocale();
    }

    protected Locale getLocaleFromAttributes() {
        Object mayBeXmlLang = this.getAttribute("http://www.w3.org/XML/1998/namespace", "lang");
        if (mayBeXmlLang instanceof String) {
            return LocaleUtility.createLocale((String)((String)mayBeXmlLang));
        }
        if (mayBeXmlLang instanceof Locale) {
            return (Locale)mayBeXmlLang;
        }
        Object mayBeXhtmlLang = this.getAttribute("http://www.w3.org/1999/xhtml", "lang");
        if (mayBeXhtmlLang instanceof String) {
            return LocaleUtility.createLocale((String)((String)mayBeXhtmlLang));
        }
        if (mayBeXhtmlLang instanceof Locale) {
            return (Locale)mayBeXhtmlLang;
        }
        return null;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public void setVirtual(boolean virtual) {
        this.virtual = virtual;
    }

    public Object clone() throws CloneNotSupportedException {
        Element element = (Element)super.clone();
        element.style = (CSSStyleRule)this.style.clone();
        if (this.attributes != null) {
            element.attributes = (AttributeMap)this.attributes.clone();
        }
        if (this.attributeExpressions != null) {
            element.attributeExpressions = (AttributeMap)this.attributeExpressions.clone();
            String[] namespaces = element.attributeExpressions.getNameSpaces();
            for (int i = 0; i < namespaces.length; ++i) {
                String namespace = namespaces[i];
                Map attrsNs = element.attributeExpressions.getAttributes(namespace);
                Iterator it = attrsNs.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    Expression exp = (Expression)entry.getValue();
                    entry.setValue(exp.clone());
                }
            }
        }
        if (this.expressions != null) {
            element.expressions = (ArrayList)this.expressions.clone();
            element.expressions.clear();
            for (int i = 0; i < this.expressions.size(); ++i) {
                Expression expression = (Expression)this.expressions.get(i);
                element.expressions.add(expression.clone());
            }
        }
        if (this.styleExpressions != null) {
            element.styleExpressions = (HashMap)this.styleExpressions.clone();
            Iterator styleExpressionsIt = element.styleExpressions.entrySet().iterator();
            while (styleExpressionsIt.hasNext()) {
                Map.Entry entry = styleExpressionsIt.next();
                Expression exp = (Expression)entry.getValue();
                entry.setValue(exp.clone());
            }
        }
        if (this.displayCondition != null) {
            element.displayCondition = (Expression)this.displayCondition.clone();
        }
        return element;
    }
}

