/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.misc.tablemodel;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.table.DefaultTableModel;
import org.jfree.report.JFreeReportBoot;
import org.jfree.report.modules.misc.tablemodel.CloseableTableModel;
import org.jfree.report.modules.misc.tablemodel.ScrollableResultSetTableModel;
import org.jfree.util.Log;

public final class ResultSetTableModelFactory {
    public static final String COLUMN_NAME_MAPPING_KEY = "org.jfree.report.modules.misc.tablemodel.ColumnNameMapping";
    public static final String RESULTSET_FACTORY_MODE = "org.jfree.report.modules.misc.tablemodel.TableFactoryMode";
    private static ResultSetTableModelFactory defaultInstance;

    private ResultSetTableModelFactory() {
    }

    public CloseableTableModel createTableModel(ResultSet rs) throws SQLException {
        return this.createTableModel(rs, "Label".equals(JFreeReportBoot.getInstance().getGlobalConfig().getConfigProperty(COLUMN_NAME_MAPPING_KEY, "Label")));
    }

    public CloseableTableModel createTableModel(ResultSet rs, boolean labelMapping) throws SQLException {
        String prop = JFreeReportBoot.getInstance().getGlobalConfig().getConfigProperty(RESULTSET_FACTORY_MODE, "");
        if ("simple".equalsIgnoreCase(prop)) {
            return this.generateDefaultTableModel(rs, labelMapping);
        }
        int resultSetType = 1003;
        try {
            resultSetType = rs.getType();
        }
        catch (SQLException sqle) {
            Log.info((Object)"ResultSet type could not be determined, assuming default table model.");
        }
        if (resultSetType == 1003) {
            return this.generateDefaultTableModel(rs, labelMapping);
        }
        return new ScrollableResultSetTableModel(rs, labelMapping);
    }

    public CloseableTableModel generateDefaultTableModel(ResultSet rs) throws SQLException {
        return this.generateDefaultTableModel(rs, "Label".equals(JFreeReportBoot.getInstance().getGlobalConfig().getConfigProperty(COLUMN_NAME_MAPPING_KEY, "Label")));
    }

    public CloseableTableModel generateDefaultTableModel(ResultSet rs, boolean labelMapping) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int colcount = rsmd.getColumnCount();
        ArrayList<String> header = new ArrayList<String>(colcount);
        for (int i = 0; i < colcount; ++i) {
            String name;
            if (labelMapping) {
                name = rsmd.getColumnLabel(i + 1);
                header.add(name);
                continue;
            }
            name = rsmd.getColumnName(i + 1);
            header.add(name);
        }
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        while (rs.next()) {
            Object[] column = new Object[colcount];
            for (int i = 0; i < colcount; ++i) {
                Object val;
                column[i] = val = rs.getObject(i + 1);
            }
            rows.add(column);
        }
        Object[] tempRows = rows.toArray();
        Object[][] rowMap = new Object[tempRows.length][];
        for (int i = 0; i < tempRows.length; ++i) {
            rowMap[i] = (Object[])tempRows[i];
        }
        CloseableDefaultTableModel model = new CloseableDefaultTableModel(rowMap, header.toArray(), rs);
        for (int i = 0; i < colcount; ++i) {
        }
        return model;
    }

    public static synchronized ResultSetTableModelFactory getInstance() {
        if (defaultInstance == null) {
            defaultInstance = new ResultSetTableModelFactory();
        }
        return defaultInstance;
    }

    private static final class CloseableDefaultTableModel
    extends DefaultTableModel
    implements CloseableTableModel {
        private final ResultSet res;

        private CloseableDefaultTableModel(Object[][] objects, Object[] objects1, ResultSet res) {
            super(objects, objects1);
            this.res = res;
        }

        public void close() {
            this.setDataVector(new Object[0][0], new Object[0]);
            try {
                this.res.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

