/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.misc.tablemodel;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.swing.table.TableModel;
import org.jfree.report.modules.misc.tablemodel.CSVTableModel;
import org.jfree.report.util.CSVTokenizer;

public class CSVTableModelProducer {
    private BufferedReader reader;
    private String separator;
    private CSVTableModel tableModel;
    private boolean columnNameFirst;

    public CSVTableModelProducer(InputStream in) {
        this(new BufferedReader(new InputStreamReader(in)));
    }

    public CSVTableModelProducer(String filename) throws FileNotFoundException {
        this(new BufferedReader(new FileReader(filename)));
    }

    public CSVTableModelProducer(BufferedReader r) {
        if (r == null) {
            throw new NullPointerException("The input stream must not be null");
        }
        this.reader = r;
        this.separator = ",";
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public synchronized TableModel parse() throws IOException {
        String line;
        if (this.tableModel != null) {
            return this.tableModel;
        }
        this.tableModel = new CSVTableModel();
        if (this.columnNameFirst) {
            String first = this.reader.readLine();
            if (first == null) {
                return this.tableModel;
            }
            this.tableModel.setColumnNames(this.splitLine(first));
        }
        ArrayList<String[]> data = new ArrayList<String[]>();
        int maxLength = 0;
        while ((line = this.reader.readLine()) != null) {
            String[] o = this.splitLine(line);
            if (o.length > maxLength) {
                maxLength = o.length;
            }
            data.add(o);
        }
        this.close();
        Object[][] array = new Object[data.size()][];
        data.toArray((T[])array);
        this.tableModel.setData(array);
        return this.tableModel;
    }

    private String[] splitLine(String line) {
        ArrayList<Object> row = new ArrayList<Object>();
        CSVTokenizer tokenizer = new CSVTokenizer(line, this.getSeparator());
        while (tokenizer.hasMoreElements()) {
            row.add(tokenizer.nextElement());
        }
        return row.toArray(new String[row.size()]);
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public TableModel getTableModel() throws IOException {
        return this.parse();
    }

    public boolean isColumnNameFirstLine() {
        return this.columnNameFirst;
    }

    public void setColumnNameFirstLine(boolean columnNameFirst) {
        this.columnNameFirst = columnNameFirst;
    }
}

