/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.misc.autotable.xml;

import java.util.ArrayList;
import org.jfree.report.modules.factories.report.base.NodeReadHandler;
import org.jfree.report.modules.factories.report.base.NodeReadHandlerFactory;
import org.jfree.report.modules.factories.report.flow.AbstractElementReadHandler;
import org.jfree.report.modules.misc.autotable.AutoTableElement;
import org.jfree.report.structure.Element;
import org.jfree.report.structure.Section;
import org.jfree.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AutoTableElementReadHandler
extends AbstractElementReadHandler {
    private AutoTableElement autoTableElement = new AutoTableElement();
    private ArrayList headerSections = new ArrayList();
    private ArrayList footerSections;
    private ArrayList contentSections = new ArrayList();

    public AutoTableElementReadHandler() {
        this.footerSections = new ArrayList();
    }

    protected Element getElement() {
        return this.autoTableElement;
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!"http://jfreereport.sourceforge.net/namespaces/reports/flow/extension/autotable".equals(uri)) {
            return super.getHandlerForChild(uri, tagName, atts);
        }
        NodeReadHandlerFactory factory = NodeReadHandlerFactory.getInstance();
        NodeReadHandler handler = (NodeReadHandler)factory.getHandler(uri, tagName);
        if (handler == null) {
            return null;
        }
        if ("auto-table-header".equals(tagName)) {
            this.headerSections.add(handler);
            return handler;
        }
        if ("auto-table-footer".equals(tagName)) {
            this.footerSections.add(handler);
            return handler;
        }
        if ("auto-table-cell".equals(tagName)) {
            this.contentSections.add(handler);
            return handler;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        NodeReadHandler handler;
        int i;
        for (i = 0; i < this.headerSections.size(); ++i) {
            handler = (NodeReadHandler)this.headerSections.get(i);
            this.autoTableElement.addHeader((Section)handler.getNode());
        }
        for (i = 0; i < this.footerSections.size(); ++i) {
            handler = (NodeReadHandler)this.footerSections.get(i);
            this.autoTableElement.addFooter((Section)handler.getNode());
        }
        for (i = 0; i < this.contentSections.size(); ++i) {
            handler = (NodeReadHandler)this.contentSections.get(i);
            this.autoTableElement.addContent((Section)handler.getNode());
        }
    }
}

