/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.misc.autotable.flow;

import org.jfree.layouting.util.AttributeMap;
import org.jfree.report.DataSourceException;
import org.jfree.report.ReportDataFactoryException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.data.ReportDataRow;
import org.jfree.report.flow.FlowControlOperation;
import org.jfree.report.flow.FlowController;
import org.jfree.report.flow.ReportContext;
import org.jfree.report.flow.ReportTarget;
import org.jfree.report.flow.layoutprocessor.ElementLayoutController;
import org.jfree.report.flow.layoutprocessor.LayoutController;
import org.jfree.report.flow.layoutprocessor.LayoutControllerFactory;
import org.jfree.report.flow.layoutprocessor.LayoutControllerUtil;
import org.jfree.report.modules.misc.autotable.AutoTableElement;

public class AutoTableLayoutController
extends ElementLayoutController {
    public static final int HANDLING_HEADER = 0;
    public static final int HANDLING_DATA = 1;
    public static final int HANDLING_FOOTER = 2;
    private int currentColumn;
    private int processingState;
    private int columnCount;

    public void initialize(Object node, FlowController flowController, LayoutController parent) throws DataSourceException, ReportDataFactoryException, ReportProcessingException {
        super.initialize(node, flowController, parent);
        ReportDataRow reportDataRow = flowController.getMasterRow().getReportDataRow();
        this.columnCount = reportDataRow.getColumnCount();
    }

    protected LayoutController processContent(ReportTarget target) throws DataSourceException, ReportProcessingException, ReportDataFactoryException {
        switch (this.processingState) {
            case 0: {
                return this.processHeader(target);
            }
            case 2: {
                return this.processFooter(target);
            }
            case 1: {
                return this.processData(target);
            }
        }
        throw new ReportProcessingException("No such state.");
    }

    private LayoutController processData(ReportTarget target) throws ReportProcessingException, DataSourceException, ReportDataFactoryException {
        AttributeMap elementMap;
        AutoTableElement node = (AutoTableElement)this.getElement();
        if (node.getContentCount() == 0) {
            throw new ReportProcessingException("An Auto-Table must have at least one defined column.");
        }
        if (this.currentColumn == 0) {
            elementMap = LayoutControllerUtil.createEmptyMap("http://jfreereport.sourceforge.net/namespaces/reports/flow/extension/autotable", "data-row");
            target.startElement(elementMap);
        }
        if (this.currentColumn < this.columnCount) {
            FlowController flowController = this.getFlowController();
            ReportContext reportContext = flowController.getReportContext();
            LayoutControllerFactory layoutControllerFactory = reportContext.getLayoutControllerFactory();
            int idx = this.currentColumn % node.getContentCount();
            AutoTableLayoutController derived = (AutoTableLayoutController)this.clone();
            return layoutControllerFactory.create(flowController, node.getContentCell(idx), derived);
        }
        elementMap = LayoutControllerUtil.createEmptyMap("http://jfreereport.sourceforge.net/namespaces/reports/flow/extension/autotable", "data-row");
        target.endElement(elementMap);
        FlowController flowController = this.getFlowController().performOperation(FlowControlOperation.ADVANCE);
        FlowController cfc = this.tryRepeatingCommit(flowController);
        if (cfc != null) {
            AutoTableLayoutController derived = (AutoTableLayoutController)this.clone();
            derived.setFlowController(cfc);
            derived.currentColumn = 0;
            return derived;
        }
        AutoTableLayoutController derived = (AutoTableLayoutController)this.clone();
        derived.currentColumn = 0;
        derived.processingState = 2;
        return derived;
    }

    private LayoutController processFooter(ReportTarget target) throws ReportProcessingException, DataSourceException, ReportDataFactoryException {
        AttributeMap elementMap;
        AutoTableElement node = (AutoTableElement)this.getElement();
        if (node.getFooterCount() == 0) {
            AutoTableLayoutController derived = (AutoTableLayoutController)this.clone();
            derived.currentColumn = 0;
            derived.processingState = -1;
            derived.setProcessingState(3);
            return derived;
        }
        if (this.currentColumn == 0) {
            elementMap = LayoutControllerUtil.createEmptyMap("http://jfreereport.sourceforge.net/namespaces/reports/flow/extension/autotable", "footer-row");
            target.startElement(elementMap);
        }
        if (this.currentColumn < this.columnCount) {
            FlowController flowController = this.getFlowController();
            ReportContext reportContext = flowController.getReportContext();
            LayoutControllerFactory layoutControllerFactory = reportContext.getLayoutControllerFactory();
            int idx = this.currentColumn % node.getFooterCount();
            AutoTableLayoutController derived = (AutoTableLayoutController)this.clone();
            return layoutControllerFactory.create(flowController, node.getFooterCell(idx), derived);
        }
        elementMap = LayoutControllerUtil.createEmptyMap("http://jfreereport.sourceforge.net/namespaces/reports/flow/extension/autotable", "footer-row");
        target.endElement(elementMap);
        AutoTableLayoutController derived = (AutoTableLayoutController)this.clone();
        derived.currentColumn = 0;
        derived.processingState = -1;
        derived.setProcessingState(3);
        return derived;
    }

    private LayoutController processHeader(ReportTarget target) throws ReportProcessingException, DataSourceException, ReportDataFactoryException {
        AttributeMap elementMap;
        AutoTableElement node = (AutoTableElement)this.getElement();
        if (node.getHeaderCount() == 0) {
            AutoTableLayoutController derived = (AutoTableLayoutController)this.clone();
            derived.currentColumn = 0;
            derived.processingState = 1;
            return derived;
        }
        if (this.currentColumn == 0) {
            elementMap = LayoutControllerUtil.createEmptyMap("http://jfreereport.sourceforge.net/namespaces/reports/flow/extension/autotable", "header-row");
            target.startElement(elementMap);
        }
        if (this.currentColumn < this.columnCount) {
            FlowController flowController = this.getFlowController();
            ReportContext reportContext = flowController.getReportContext();
            LayoutControllerFactory layoutControllerFactory = reportContext.getLayoutControllerFactory();
            int idx = this.currentColumn % node.getHeaderCount();
            AutoTableLayoutController derived = (AutoTableLayoutController)this.clone();
            return layoutControllerFactory.create(flowController, node.getHeaderCell(idx), derived);
        }
        elementMap = LayoutControllerUtil.createEmptyMap("http://jfreereport.sourceforge.net/namespaces/reports/flow/extension/autotable", "header-row");
        target.endElement(elementMap);
        AutoTableLayoutController derived = (AutoTableLayoutController)this.clone();
        derived.currentColumn = 0;
        derived.processingState = 1;
        return derived;
    }

    public LayoutController join(FlowController flowController) {
        AutoTableLayoutController derived = (AutoTableLayoutController)this.clone();
        derived.setFlowController(flowController);
        ++derived.currentColumn;
        return derived;
    }

    public int getCurrentColumn() {
        return this.currentColumn;
    }
}

