/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.misc.autotable.flow;

import org.jfree.report.DataFlags;
import org.jfree.report.DataSourceException;
import org.jfree.report.ReportDataFactoryException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.data.ReportDataRow;
import org.jfree.report.flow.FlowController;
import org.jfree.report.flow.ReportTarget;
import org.jfree.report.flow.layoutprocessor.ElementLayoutController;
import org.jfree.report.flow.layoutprocessor.LayoutController;
import org.jfree.report.modules.misc.autotable.AutoTableCellContent;
import org.jfree.report.modules.misc.autotable.flow.AutoTableLayoutController;

public class AutoTableItemLayoutController
extends ElementLayoutController {
    protected AutoTableLayoutController findTableParent() {
        for (LayoutController parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof AutoTableLayoutController)) continue;
            return (AutoTableLayoutController)parent;
        }
        return null;
    }

    protected LayoutController processContent(ReportTarget target) throws DataSourceException, ReportProcessingException, ReportDataFactoryException {
        AutoTableCellContent content = (AutoTableCellContent)this.getElement();
        FlowController flowController = this.getFlowController();
        ReportDataRow reportDataRow = flowController.getMasterRow().getReportDataRow();
        AutoTableLayoutController table = this.findTableParent();
        if (table == null) {
            throw new ReportProcessingException("Invalid state: have no auto-table as context.");
        }
        int currentColumn = table.getCurrentColumn();
        if ("name".equals(content.getItem())) {
            String columnName = reportDataRow.getColumnName(currentColumn);
            target.processText(columnName);
        } else if ("value".equals(content.getItem())) {
            DataFlags flags = reportDataRow.getFlags(currentColumn);
            target.processContent(flags);
        } else {
            throw new ReportProcessingException("Invalid definition: Content-Item with no valid type");
        }
        AutoTableItemLayoutController derived = (AutoTableItemLayoutController)this.clone();
        derived.setProcessingState(3);
        derived.setFlowController(flowController);
        return derived;
    }

    public LayoutController join(FlowController flowController) {
        AutoTableItemLayoutController derived = (AutoTableItemLayoutController)this.clone();
        derived.setProcessingState(3);
        derived.setFlowController(flowController);
        return derived;
    }
}

