/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.swing.printing;

import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import org.jfree.layouting.StateException;
import org.jfree.layouting.modules.output.graphics.GraphicsContentInterceptor;
import org.jfree.layouting.modules.output.graphics.GraphicsOutputProcessor;
import org.jfree.layouting.modules.output.graphics.PageDrawable;
import org.jfree.layouting.modules.output.graphics.QueryPhysicalPageInterceptor;
import org.jfree.layouting.output.OutputProcessor;
import org.jfree.layouting.output.pageable.PageableOutputProcessor;
import org.jfree.report.DataSourceException;
import org.jfree.report.ReportDataFactory;
import org.jfree.report.ReportDataFactoryException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.flow.LibLayoutReportTarget;
import org.jfree.report.flow.ReportJob;
import org.jfree.report.flow.ReportTargetState;
import org.jfree.report.flow.layoutprocessor.LayoutController;
import org.jfree.report.flow.paginating.PageState;
import org.jfree.report.flow.paginating.PaginatingReportProcessor;
import org.jfree.report.modules.gui.swing.printing.DrawablePrintable;
import org.jfree.ui.Drawable;
import org.jfree.util.Configuration;
import org.jfree.util.Log;

public class PrintReportProcessor
extends PaginatingReportProcessor
implements Pageable {
    private ReportJob job;
    private Throwable error;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrintReportProcessor(ReportJob job) {
        super((PageableOutputProcessor)new GraphicsOutputProcessor((Configuration)job.getConfiguration()));
        this.job = job;
        ReportJob reportJob = job;
        synchronized (reportJob) {
            ReportDataFactory dataFactory = job.getDataFactory();
            if (dataFactory != null) {
                dataFactory.open();
            }
        }
    }

    protected GraphicsOutputProcessor getGraphicsProcessor() {
        return (GraphicsOutputProcessor)this.getOutputProcessor();
    }

    public boolean isError() {
        return this.error != null;
    }

    protected ReportJob getJob() {
        return this.job;
    }

    public void close() {
        this.getJob().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PageDrawable processPage(int page) throws ReportDataFactoryException, DataSourceException, ReportProcessingException, StateException {
        ReportJob job;
        ReportJob reportJob = job = this.getJob();
        synchronized (reportJob) {
            PageState state = this.getPhysicalPageState(page);
            ReportTargetState targetState = state.getTargetState();
            GraphicsOutputProcessor outputProcessor = this.getGraphicsProcessor();
            outputProcessor.setPageCursor(state.getPageCursor());
            QueryPhysicalPageInterceptor interceptor = new QueryPhysicalPageInterceptor(outputProcessor.getPhysicalPage(page));
            outputProcessor.setInterceptor((GraphicsContentInterceptor)interceptor);
            LibLayoutReportTarget target = (LibLayoutReportTarget)targetState.restore((OutputProcessor)outputProcessor);
            LayoutController position = state.getLayoutController();
            while (position.isAdvanceable()) {
                position = position.advance(target);
                target.commit();
                while (!position.isAdvanceable() && position.getParent() != null) {
                    LayoutController parent = position.getParent();
                    position = parent.join(position.getFlowController());
                }
                if (interceptor.isMoreContentNeeded()) continue;
                outputProcessor.setInterceptor(null);
                return interceptor.getDrawable();
            }
            outputProcessor.setInterceptor(null);
            return interceptor.getDrawable();
        }
    }

    public synchronized int getNumberOfPages() {
        if (this.isError()) {
            return 0;
        }
        if (!this.isPaginated()) {
            try {
                this.prepareReportProcessing(this.getJob());
            }
            catch (Exception e) {
                Log.debug((Object)"PrintReportProcessor: ", (Exception)e);
                this.error = e;
                return 0;
            }
        }
        Log.debug((Object)("After pagination, we have " + this.getGraphicsProcessor().getPhysicalPageCount() + " physical pages."));
        return this.getGraphicsProcessor().getPhysicalPageCount();
    }

    public boolean paginate() {
        if (this.isError()) {
            return false;
        }
        if (!this.isPaginated()) {
            try {
                this.prepareReportProcessing(this.getJob());
                return true;
            }
            catch (Exception e) {
                this.error = e;
                return false;
            }
        }
        return true;
    }

    public synchronized PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        if (this.isError()) {
            return null;
        }
        if (!this.isPaginated()) {
            try {
                this.prepareReportProcessing(this.getJob());
            }
            catch (Exception e) {
                this.error = e;
                return null;
            }
        }
        try {
            PageDrawable pageDrawable = this.processPage(pageIndex);
            return pageDrawable.getPageFormat();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to return a valid pageformat.");
        }
    }

    public synchronized Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        if (this.isError()) {
            return null;
        }
        if (!this.isPaginated()) {
            try {
                this.prepareReportProcessing(this.getJob());
            }
            catch (Exception e) {
                this.error = e;
                return null;
            }
        }
        try {
            PageDrawable pageDrawable = this.processPage(pageIndex);
            return new DrawablePrintable((Drawable)pageDrawable);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to return a valid pageformat.");
        }
    }

    public PageDrawable getPageDrawable(int pageIndex) {
        if (this.isError()) {
            return null;
        }
        if (!this.isPaginated()) {
            try {
                this.prepareReportProcessing(this.getJob());
            }
            catch (Exception e) {
                this.error = e;
                return null;
            }
        }
        try {
            return this.processPage(pageIndex);
        }
        catch (Exception e) {
            this.error = e;
            Log.debug((Object)"Failed to process the page", (Exception)e);
            throw new IllegalStateException("Unable to return a valid pageformat.");
        }
    }

    public final void processReport(ReportJob job) {
        throw new UnsupportedOperationException("Printing is a passive process.");
    }
}

