/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.swing.preview.actions;

import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.jfree.report.modules.gui.swing.common.AbstractActionPlugin;
import org.jfree.report.modules.gui.swing.common.SwingGuiContext;
import org.jfree.report.modules.gui.swing.preview.PreviewPane;
import org.jfree.report.modules.gui.swing.preview.actions.ControlActionPlugin;
import org.jfree.util.Log;
import org.jfree.util.ResourceBundleSupport;

public class GoToActionPlugin
extends AbstractActionPlugin
implements ControlActionPlugin {
    private ResourceBundleSupport resources;

    public boolean initialize(SwingGuiContext context) {
        super.initialize(context);
        this.resources = new ResourceBundleSupport(context.getLocale(), "org.jfree.report.modules.gui.swing.preview.resources");
        return true;
    }

    protected String getConfigurationPrefix() {
        return "org.jfree.report.modules.gui.swing.preview.go-to.";
    }

    public String getDisplayName() {
        return this.resources.getString("action.gotopage.name");
    }

    public String getShortDescription() {
        return this.resources.getString("action.gotopage.description");
    }

    public Icon getSmallIcon() {
        Locale locale = this.getContext().getLocale();
        return this.getIconTheme().getSmallIcon(locale, "action.gotopage.small-icon");
    }

    public Icon getLargeIcon() {
        Locale locale = this.getContext().getLocale();
        return this.getIconTheme().getLargeIcon(locale, "action.gotopage.icon");
    }

    public KeyStroke getAcceleratorKey() {
        return this.resources.getKeyStroke("action.gotopage.accelerator");
    }

    public Integer getMnemonicKey() {
        return this.resources.getMnemonic("action.gotopage.mnemonic");
    }

    public boolean configure(PreviewPane reportPane) {
        String result = JOptionPane.showInputDialog(this.getContext().getWindow(), this.resources.getString("dialog.gotopage.title"), this.resources.getString("dialog.gotopage.message"), 2);
        if (result == null) {
            return false;
        }
        try {
            int page = Integer.parseInt(result);
            if (page > 0 && page <= reportPane.getNumberOfPages()) {
                reportPane.setPageNumber(page);
            }
        }
        catch (Exception ex) {
            Log.info((Object)"DefaultGotoAction: swallowed an exception");
        }
        return false;
    }
}

