/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.swing.preview;

import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.jfree.report.modules.gui.common.DefaultIconTheme;
import org.jfree.report.modules.gui.common.IconTheme;
import org.jfree.report.modules.gui.swing.common.ActionFactory;
import org.jfree.report.modules.gui.swing.common.ActionPlugin;
import org.jfree.report.modules.gui.swing.common.ActionPluginMenuComparator;
import org.jfree.report.modules.gui.swing.common.DefaultActionFactory;
import org.jfree.report.modules.gui.swing.common.ExportActionPlugin;
import org.jfree.report.modules.gui.swing.common.SwingGuiContext;
import org.jfree.report.modules.gui.swing.preview.ActionCategory;
import org.jfree.report.modules.gui.swing.preview.CategoryTreeItem;
import org.jfree.report.modules.gui.swing.preview.PreviewPane;
import org.jfree.report.modules.gui.swing.preview.actions.ControlAction;
import org.jfree.report.modules.gui.swing.preview.actions.ControlActionPlugin;
import org.jfree.report.modules.gui.swing.preview.actions.ExportAction;
import org.jfree.report.modules.gui.swing.preview.actions.ZoomAction;
import org.jfree.report.modules.gui.swing.preview.actions.ZoomListActionPlugin;
import org.jfree.report.util.TextUtilities;
import org.jfree.ui.FloatingButtonEnabler;
import org.jfree.ui.KeyedComboBoxModel;
import org.jfree.ui.action.ActionButton;
import org.jfree.ui.action.ActionMenuItem;
import org.jfree.util.Configuration;
import org.jfree.util.Log;
import org.jfree.util.ObjectUtilities;

public class PreviewPaneUtilities {
    private static final String ICON_THEME_CONFIG_KEY = "org.jfree.report.modules.gui.common.IconTheme";
    private static final String ACTION_FACTORY_CONFIG_KEY = "org.jfree.report.modules.gui.swing.preview.ActionFactory";
    private static final String CATEGORY_PREFIX = "org.jfree.report.modules.gui.swing.category.";
    static /* synthetic */ Class class$org$jfree$report$modules$gui$swing$preview$PreviewPane;
    static /* synthetic */ Class class$org$jfree$report$modules$gui$common$IconTheme;
    static /* synthetic */ Class class$org$jfree$report$modules$gui$swing$common$ActionFactory;
    static /* synthetic */ Class class$org$jfree$report$modules$gui$swing$preview$ActionCategory;

    private PreviewPaneUtilities() {
    }

    public static JMenu createMenu(ActionCategory cat) {
        String toolTip;
        JMenu menu = new JMenu();
        menu.setText(cat.getDisplayName());
        Integer mnemonicKey = cat.getMnemonicKey();
        if (mnemonicKey != null) {
            menu.setMnemonic(mnemonicKey);
        }
        if ((toolTip = cat.getShortDescription()) != null && toolTip.length() > 0) {
            menu.setToolTipText(toolTip);
        }
        return menu;
    }

    public static int buildMenu(JMenu menu, ActionPlugin[] actions, PreviewPane pane) {
        if (actions.length == 0) {
            return 0;
        }
        Arrays.sort(actions, new ActionPluginMenuComparator());
        boolean separatorPending = false;
        int count = 0;
        for (int i = 0; i < actions.length; ++i) {
            AbstractAction action;
            ActionPlugin actionPlugin = actions[i];
            if (!actionPlugin.isAddToMenu()) continue;
            if (count > 0 && separatorPending) {
                menu.addSeparator();
                separatorPending = false;
            }
            if (actionPlugin instanceof ExportActionPlugin) {
                ExportActionPlugin exportPlugin = (ExportActionPlugin)actionPlugin;
                action = new ExportAction(exportPlugin, pane);
                menu.add((JMenuItem)new ActionMenuItem((Action)action));
                ++count;
            } else if (actionPlugin instanceof ControlActionPlugin) {
                ControlActionPlugin controlPlugin = (ControlActionPlugin)actionPlugin;
                action = new ControlAction(controlPlugin, pane);
                menu.add((JMenuItem)new ActionMenuItem((Action)action));
                ++count;
            } else if (actionPlugin instanceof ZoomListActionPlugin) {
                PreviewPaneUtilities.buildViewMenu(menu, pane);
            }
            if (!actionPlugin.isSeparated()) continue;
            separatorPending = true;
        }
        return count;
    }

    private static void buildViewMenu(JMenu zoom, PreviewPane pane) {
        double[] zoomFactors = pane.getZoomFactors();
        for (int i = 0; i < zoomFactors.length; ++i) {
            double factor = zoomFactors[i];
            zoom.add((JMenuItem)new ActionMenuItem((Action)new ZoomAction(factor, pane)));
        }
    }

    public static void addActionsToToolBar(JToolBar toolBar, ActionPlugin[] reportActions, PreviewPane pane) {
        if (reportActions == null) {
            return;
        }
        boolean separatorPending = false;
        int count = 0;
        for (int i = 0; i < reportActions.length; ++i) {
            AbstractAction action;
            ActionPlugin actionPlugin = reportActions[i];
            if (!actionPlugin.isAddToToolbar()) continue;
            if (count > 0 && separatorPending) {
                toolBar.addSeparator();
                separatorPending = false;
            }
            if (actionPlugin instanceof ExportActionPlugin) {
                ExportActionPlugin exportPlugin = (ExportActionPlugin)actionPlugin;
                action = new ExportAction(exportPlugin, pane);
                toolBar.add(PreviewPaneUtilities.createButton(action, pane.getSwingGuiContext()));
                ++count;
            } else if (actionPlugin instanceof ControlActionPlugin) {
                ControlActionPlugin controlPlugin = (ControlActionPlugin)actionPlugin;
                action = new ControlAction(controlPlugin, pane);
                toolBar.add(PreviewPaneUtilities.createButton(action, pane.getSwingGuiContext()));
                ++count;
            } else if (actionPlugin instanceof ZoomListActionPlugin) {
                JPanel zoomPane = new JPanel();
                zoomPane.setLayout(new FlowLayout(0));
                zoomPane.add(PreviewPaneUtilities.createZoomSelector(pane));
                toolBar.add(zoomPane);
                ++count;
            }
            if (!actionPlugin.isSeparated()) continue;
            separatorPending = true;
        }
    }

    private static JComboBox createZoomSelector(PreviewPane pane) {
        JComboBox zoomSelect = new JComboBox(pane.getZoomModel());
        zoomSelect.addActionListener(new ZoomSelectAction(pane.getZoomModel(), pane));
        zoomSelect.setAlignmentX(1.0f);
        return zoomSelect;
    }

    private static JButton createButton(Action action, SwingGuiContext swingGuiContext) {
        Icon icon;
        ActionButton button = new ActionButton(action);
        boolean needText = true;
        if (PreviewPaneUtilities.isLargeButtonsEnabled(swingGuiContext)) {
            icon = (Icon)action.getValue("Icon24");
            if (icon != null && icon.getIconHeight() > 1 && icon.getIconHeight() > 1) {
                button.setIcon(icon);
                needText = false;
            }
        } else {
            icon = (Icon)action.getValue("SmallIcon");
            if (icon != null && icon.getIconHeight() > 1 && icon.getIconHeight() > 1) {
                button.setIcon(icon);
                needText = false;
            }
        }
        if (needText) {
            Object value = action.getValue("Name");
            if (value != null) {
                button.setText(String.valueOf(value));
            }
        } else {
            button.setText(null);
            button.setMargin(new Insets(0, 0, 0, 0));
        }
        FloatingButtonEnabler.getInstance().addButton((AbstractButton)button);
        return button;
    }

    private static boolean isLargeButtonsEnabled(SwingGuiContext swingGuiContext) {
        Configuration configuration = swingGuiContext.getConfiguration();
        return "true".equals(configuration.getConfigProperty("org.jfree.report.modules.gui.swing.preview.LargeIcons"));
    }

    public static double getNextZoomOut(double zoom, double[] zoomFactors) {
        if (zoom <= zoomFactors[0]) {
            return zoom * 2.0 / 3.0;
        }
        double largestZoom = zoomFactors[zoomFactors.length - 1];
        if (zoom > largestZoom) {
            double linear = zoom * 2.0 / 3.0;
            if (linear < largestZoom) {
                return largestZoom;
            }
            return linear;
        }
        for (int i = zoomFactors.length - 1; i >= 0; --i) {
            double factor = zoomFactors[i];
            if (!(factor < zoom)) continue;
            return factor;
        }
        return zoom * 2.0 / 3.0;
    }

    public static double getNextZoomIn(double zoom, double[] zoomFactors) {
        double largestZoom = zoomFactors[zoomFactors.length - 1];
        if (zoom >= largestZoom) {
            return zoom * 1.5;
        }
        double smallestZoom = zoomFactors[0];
        if (zoom < smallestZoom) {
            double linear = zoom * 1.5;
            if (linear > smallestZoom) {
                return smallestZoom;
            }
            return linear;
        }
        for (int i = 0; i < zoomFactors.length; ++i) {
            double factor = zoomFactors[i];
            if (!(factor > zoom)) continue;
            return factor;
        }
        return zoom * 1.5;
    }

    public static IconTheme createIconTheme(Configuration config) {
        String themeClass = config.getConfigProperty(ICON_THEME_CONFIG_KEY);
        Object maybeTheme = ObjectUtilities.loadAndInstantiate((String)themeClass, (Class)(class$org$jfree$report$modules$gui$swing$preview$PreviewPane == null ? (class$org$jfree$report$modules$gui$swing$preview$PreviewPane = PreviewPaneUtilities.class$("org.jfree.report.modules.gui.swing.preview.PreviewPane")) : class$org$jfree$report$modules$gui$swing$preview$PreviewPane), (Class)(class$org$jfree$report$modules$gui$common$IconTheme == null ? (class$org$jfree$report$modules$gui$common$IconTheme = PreviewPaneUtilities.class$(ICON_THEME_CONFIG_KEY)) : class$org$jfree$report$modules$gui$common$IconTheme));
        IconTheme iconTheme = maybeTheme != null ? (IconTheme)maybeTheme : new DefaultIconTheme();
        iconTheme.initialize(config);
        return iconTheme;
    }

    public static ActionFactory createActionFactory(Configuration config) {
        String factoryClass = config.getConfigProperty(ACTION_FACTORY_CONFIG_KEY);
        Object maybeFactory = ObjectUtilities.loadAndInstantiate((String)factoryClass, (Class)(class$org$jfree$report$modules$gui$swing$preview$PreviewPane == null ? (class$org$jfree$report$modules$gui$swing$preview$PreviewPane = PreviewPaneUtilities.class$("org.jfree.report.modules.gui.swing.preview.PreviewPane")) : class$org$jfree$report$modules$gui$swing$preview$PreviewPane), (Class)(class$org$jfree$report$modules$gui$swing$common$ActionFactory == null ? (class$org$jfree$report$modules$gui$swing$common$ActionFactory = PreviewPaneUtilities.class$("org.jfree.report.modules.gui.swing.common.ActionFactory")) : class$org$jfree$report$modules$gui$swing$common$ActionFactory));
        ActionFactory actionFactory = maybeFactory != null ? (ActionFactory)maybeFactory : new DefaultActionFactory();
        return actionFactory;
    }

    public static CategoryTreeItem[] buildMenuTree(ActionCategory[] categories) {
        CategoryTreeItem item;
        int j;
        CategoryTreeItem[] tree = new CategoryTreeItem[categories.length];
        for (int i = 0; i < categories.length; ++i) {
            ActionCategory category = categories[i];
            tree[i] = new CategoryTreeItem(category);
        }
        for (j = 0; j < tree.length; ++j) {
            item = tree[j];
            String itemName = item.getName();
            int parentWeight = 0;
            CategoryTreeItem parent = null;
            for (int k = 0; k < tree.length; ++k) {
                CategoryTreeItem treeItem;
                String parentName;
                if (k == j || !itemName.startsWith(parentName = (treeItem = tree[k]).getName()) || parentName.length() <= parentWeight) continue;
                parent = treeItem;
                parentWeight = parentName.length();
            }
            item.setParent(parent);
        }
        for (j = 0; j < tree.length; ++j) {
            item = tree[j];
            CategoryTreeItem parent = item.getParent();
            if (parent == null) continue;
            parent.add(item);
        }
        return tree;
    }

    public static HashMap loadActions(SwingGuiContext swingGuiContext) {
        HashMap<ActionCategory, ActionPlugin[]> actions = new HashMap<ActionCategory, ActionPlugin[]>();
        Configuration configuration = swingGuiContext.getConfiguration();
        ActionCategory[] categories = PreviewPaneUtilities.loadCategories(swingGuiContext);
        ActionFactory factory = PreviewPaneUtilities.createActionFactory(configuration);
        for (int i = 0; i < categories.length; ++i) {
            ActionCategory category = categories[i];
            actions.put(category, factory.getActions(swingGuiContext, category.getName()));
        }
        return actions;
    }

    public static ActionCategory[] loadCategories(SwingGuiContext swingGuiContext) {
        ArrayList<ActionCategory> categories = new ArrayList<ActionCategory>();
        Configuration configuration = swingGuiContext.getConfiguration();
        Iterator keys = configuration.findPropertyKeys(CATEGORY_PREFIX);
        while (keys.hasNext()) {
            ActionCategory actionCategory;
            String base;
            String enableKey = (String)keys.next();
            if (!enableKey.endsWith(".enabled") || !"true".equals(configuration.getConfigProperty(enableKey)) || (base = enableKey.substring(0, enableKey.length() - ".enabled".length())).length() == 0) continue;
            String categoryKey = base.substring(CATEGORY_PREFIX.length());
            String className = configuration.getConfigProperty(base + ".class");
            if (className == null) {
                actionCategory = new ActionCategory();
            } else {
                actionCategory = (ActionCategory)ObjectUtilities.loadAndInstantiate((String)className, (Class)(class$org$jfree$report$modules$gui$swing$preview$PreviewPane == null ? PreviewPaneUtilities.class$("org.jfree.report.modules.gui.swing.preview.PreviewPane") : class$org$jfree$report$modules$gui$swing$preview$PreviewPane), (Class)(class$org$jfree$report$modules$gui$swing$preview$ActionCategory == null ? PreviewPaneUtilities.class$("org.jfree.report.modules.gui.swing.preview.ActionCategory") : class$org$jfree$report$modules$gui$swing$preview$ActionCategory));
                if (actionCategory == null) {
                    actionCategory = new ActionCategory();
                }
            }
            String positionText = configuration.getConfigProperty(base + ".position");
            actionCategory.setPosition(TextUtilities.parseInt(positionText, 0));
            actionCategory.setName(categoryKey);
            actionCategory.setResourceBase(configuration.getConfigProperty(base + ".resource-base"));
            actionCategory.setResourcePrefix(configuration.getConfigProperty(base + ".resource-prefix"));
            actionCategory.initialize(swingGuiContext);
            categories.add(actionCategory);
        }
        return categories.toArray(new ActionCategory[categories.size()]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ZoomSelectAction
    extends AbstractAction {
        private KeyedComboBoxModel source;
        private PreviewPane pane;

        private ZoomSelectAction(KeyedComboBoxModel source, PreviewPane pane) {
            this.source = source;
            this.pane = pane;
        }

        public void actionPerformed(ActionEvent e) {
            Double selected = (Double)this.source.getSelectedKey();
            if (selected != null) {
                this.pane.setZoom(selected);
            } else {
                Log.warn((Object)("No selected key! : " + this.pane.getZoom()));
            }
        }
    }
}

