/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.swing.preview;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.jfree.layout.CenterLayout;
import org.jfree.layouting.modules.output.graphics.PageDrawable;
import org.jfree.report.JFreeReportBoot;
import org.jfree.report.flow.ReportJob;
import org.jfree.report.flow.ReportStructureRoot;
import org.jfree.report.modules.gui.common.IconTheme;
import org.jfree.report.modules.gui.swing.common.ActionPlugin;
import org.jfree.report.modules.gui.swing.common.SwingGuiContext;
import org.jfree.report.modules.gui.swing.common.SwingUtil;
import org.jfree.report.modules.gui.swing.preview.ActionCategory;
import org.jfree.report.modules.gui.swing.preview.CategoryTreeItem;
import org.jfree.report.modules.gui.swing.preview.PageBackgroundDrawable;
import org.jfree.report.modules.gui.swing.preview.PreviewPaneUtilities;
import org.jfree.report.modules.gui.swing.preview.ReportController;
import org.jfree.report.modules.gui.swing.printing.PrintReportProcessor;
import org.jfree.report.util.TextUtilities;
import org.jfree.report.util.Worker;
import org.jfree.ui.Drawable;
import org.jfree.ui.DrawablePanel;
import org.jfree.ui.KeyedComboBoxModel;
import org.jfree.util.Configuration;
import org.jfree.util.Log;
import org.jfree.util.ObjectUtilities;

public class PreviewPane
extends JPanel {
    private static final double[] ZOOM_FACTORS = new double[]{0.5, 0.75, 1.0, 1.2, 1.5, 2.0};
    private static final int DEFAULT_ZOOM_INDEX = 2;
    public static final String PAGE_NUMBER_PROPERTY = "pageNumber";
    public static final String NUMBER_OF_PAGES_PROPERTY = "numberOfPages";
    public static final String STATUS_TEXT_PROPERTY = "statusText";
    public static final String STATUS_TYPE_PROPERTY = "statusType";
    public static final String REPORT_CONTROLLER_PROPERTY = "reportController";
    public static final String REPORT_JOB_PROPERTY = "reportJob";
    public static final String ZOOM_PROPERTY = "zoom";
    public static final String CLOSED_PROPERTY = "closed";
    public static final String PAGINATING_PROPERTY = "paginating";
    public static final String ICON_THEME_PROPERTY = "iconTheme";
    public static final String TITLE_PROPERTY = "title";
    public static final String MENU_PROPERTY = "menu";
    private Drawable paginatingDrawable;
    private Drawable noReportDrawable;
    private PageBackgroundDrawable pageDrawable;
    private DrawablePanel drawablePanel;
    private ReportController reportController;
    private JMenu[] menus = new JMenu[0];
    private JToolBar toolBar;
    private String statusText;
    private String title;
    private int statusType;
    private boolean closed;
    private ReportJob reportJob;
    private int numberOfPages;
    private int pageNumber;
    private SwingGuiContext swingGuiContext;
    private IconTheme iconTheme;
    private double zoom;
    private boolean paginating;
    private PrintReportProcessor printReportProcessor;
    private Worker paginationWorker;
    private JPanel innerReportControllerHolder;
    private JPanel toolbarHolder;
    private JPanel outerReportControllerHolder;
    private boolean reportControllerInner;
    private String reportControllerLocation;
    private JComponent reportControllerComponent;
    private KeyedComboBoxModel zoomModel;

    public PreviewPane() {
        this.setLayout(new BorderLayout());
        this.zoomModel = new KeyedComboBoxModel();
        this.zoomModel.setAllowOtherValue(true);
        this.zoom = ZOOM_FACTORS[2];
        this.pageDrawable = new PageBackgroundDrawable();
        this.drawablePanel = new DrawablePanel();
        this.drawablePanel.setOpaque(false);
        this.drawablePanel.setBackground(Color.green);
        this.swingGuiContext = new PreviewGuiContext();
        JPanel reportPaneHolder = new JPanel((LayoutManager)new CenterLayout());
        reportPaneHolder.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        reportPaneHolder.add((Component)this.drawablePanel);
        JScrollPane s1 = new JScrollPane(reportPaneHolder);
        s1.getVerticalScrollBar().setUnitIncrement(20);
        this.innerReportControllerHolder = new JPanel();
        this.innerReportControllerHolder.setLayout(new BorderLayout());
        this.innerReportControllerHolder.add((Component)s1, "Center");
        this.toolbarHolder = new JPanel();
        this.toolbarHolder.setLayout(new BorderLayout());
        this.toolbarHolder.add((Component)this.innerReportControllerHolder, "Center");
        this.outerReportControllerHolder = new JPanel();
        this.outerReportControllerHolder.setLayout(new BorderLayout());
        this.outerReportControllerHolder.add((Component)this.toolbarHolder, "Center");
        this.add((Component)this.outerReportControllerHolder, "Center");
        this.addPropertyChangeListener(new PreviewUpdateHandler());
        this.addPropertyChangeListener(ZOOM_PROPERTY, new UpdateZoomHandler());
    }

    public synchronized PrintReportProcessor getPrintReportProcessor() {
        return this.printReportProcessor;
    }

    protected synchronized void setPrintReportProcessor(PrintReportProcessor printReportProcessor) {
        this.printReportProcessor = printReportProcessor;
    }

    public JMenu[] getMenu() {
        return this.menus;
    }

    protected void setMenu(JMenu[] menus) {
        if (menus == null) {
            throw new NullPointerException();
        }
        JMenu[] oldmenu = this.menus;
        this.menus = (JMenu[])menus.clone();
        this.firePropertyChange(MENU_PROPERTY, oldmenu, this.menus);
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public void setStatusText(String statusText) {
        String oldStatus = this.statusText;
        this.statusText = statusText;
        this.firePropertyChange(STATUS_TEXT_PROPERTY, oldStatus, statusText);
    }

    public int getStatusType() {
        return this.statusType;
    }

    public void setStatusType(int statusType) {
        int oldType = this.statusType;
        this.statusType = statusType;
        this.firePropertyChange(STATUS_TYPE_PROPERTY, oldType, statusType);
    }

    public ReportController getReportController() {
        return this.reportController;
    }

    public void setReportController(ReportController reportController) {
        ReportController oldController = this.reportController;
        this.reportController = reportController;
        this.firePropertyChange(REPORT_CONTROLLER_PROPERTY, oldController, reportController);
        this.refreshReportController(reportController);
    }

    public void refreshReportController(ReportController newReportController) {
        if (newReportController != null) {
            JComponent rcp = newReportController.getControlPanel();
            if (this.reportControllerComponent != rcp || this.reportControllerInner != newReportController.isInnerComponent() || ObjectUtilities.equal((Object)this.reportControllerLocation, (Object)newReportController.getControllerLocation())) {
                if (this.reportControllerComponent != null) {
                    this.outerReportControllerHolder.remove(this.reportControllerComponent);
                    this.innerReportControllerHolder.remove(this.reportControllerComponent);
                }
                String sanLocation = this.sanitizeLocation(newReportController.getControllerLocation());
                boolean innerComponent = newReportController.isInnerComponent();
                if (rcp != null) {
                    if (innerComponent) {
                        this.innerReportControllerHolder.add((Component)rcp, sanLocation);
                    } else {
                        this.outerReportControllerHolder.add((Component)rcp, sanLocation);
                    }
                }
                this.reportControllerComponent = rcp;
                this.reportControllerLocation = sanLocation;
                this.reportControllerInner = innerComponent;
            }
        } else {
            if (this.reportControllerComponent != null) {
                this.outerReportControllerHolder.remove(this.reportControllerComponent);
                this.innerReportControllerHolder.remove(this.reportControllerComponent);
            }
            this.reportControllerComponent = null;
        }
    }

    private String sanitizeLocation(String location) {
        if ("North".equals(location)) {
            return "North";
        }
        if ("South".equals(location)) {
            return "South";
        }
        if ("West".equals(location)) {
            return "West";
        }
        if ("East".equals(location)) {
            return "East";
        }
        return "North";
    }

    public ReportJob getReportJob() {
        return this.reportJob;
    }

    public void setReportJob(ReportJob reportJob) {
        ReportJob oldJob = this.reportJob;
        this.reportJob = reportJob;
        this.firePropertyChange(REPORT_JOB_PROPERTY, oldJob, reportJob);
        if (reportJob == null) {
            this.initializeWithoutJob();
        } else {
            this.initializeFromReport();
        }
    }

    public double getZoom() {
        return this.zoom;
    }

    public void setZoom(double zoom) {
        double oldZoom = this.zoom;
        this.zoom = zoom;
        this.firePropertyChange(ZOOM_PROPERTY, oldZoom, zoom);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        boolean oldClosed = this.closed;
        this.closed = closed;
        this.firePropertyChange(CLOSED_PROPERTY, oldClosed, closed);
        if (closed) {
            this.prepareShutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareShutdown() {
        PreviewPane previewPane = this;
        synchronized (previewPane) {
            if (this.paginationWorker != null) {
                Worker worker = this.paginationWorker;
                synchronized (worker) {
                    this.paginationWorker.finish();
                }
                this.paginationWorker = null;
            }
            if (this.printReportProcessor != null) {
                this.printReportProcessor.close();
                this.printReportProcessor = null;
            }
            this.closeToolbar();
        }
    }

    private int getUserDefinedCategoryPosition() {
        return TextUtilities.parseInt(this.swingGuiContext.getConfiguration().getConfigProperty("org.jfree.report.modules.gui.swing.user-defined-category.position"), 15000);
    }

    public Locale getLocale() {
        ReportStructureRoot report = this.getReportJob().getReportStructureRoot();
        if (report != null) {
            return report.getLocale();
        }
        return super.getLocale();
    }

    public int getNumberOfPages() {
        return this.numberOfPages;
    }

    public void setNumberOfPages(int numberOfPages) {
        int oldPageNumber = this.numberOfPages;
        this.numberOfPages = numberOfPages;
        this.firePropertyChange(NUMBER_OF_PAGES_PROPERTY, oldPageNumber, numberOfPages);
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        int oldPageNumber = this.pageNumber;
        this.pageNumber = pageNumber;
        Log.debug((Object)("Setting PageNumber: " + pageNumber));
        this.firePropertyChange(PAGE_NUMBER_PROPERTY, oldPageNumber, pageNumber);
    }

    public IconTheme getIconTheme() {
        return this.iconTheme;
    }

    protected void setIconTheme(IconTheme theme) {
        IconTheme oldTheme = this.iconTheme;
        this.iconTheme = theme;
        this.firePropertyChange(ICON_THEME_PROPERTY, oldTheme, theme);
    }

    protected void initializeFromReport() {
        this.setIconTheme(PreviewPaneUtilities.createIconTheme((Configuration)this.reportJob.getConfiguration()));
        this.zoomModel.clear();
        for (int i = 0; i < ZOOM_FACTORS.length; ++i) {
            this.zoomModel.add((Object)new Double(ZOOM_FACTORS[i]), (Object)this.formatZoomText(ZOOM_FACTORS[i]));
        }
        this.zoom = ZOOM_FACTORS[2];
        this.zoomModel.setSelectedKey((Object)new Double(ZOOM_FACTORS[2]));
        HashMap actions = PreviewPaneUtilities.loadActions(this.swingGuiContext);
        this.buildMenu(actions);
        if (this.toolBar != null) {
            this.toolbarHolder.remove(this.toolBar);
        }
        this.toolBar = this.buildToolbar(actions);
        if (this.toolBar != null) {
            this.toolbarHolder.add((Component)this.toolBar, "North");
        }
        this.startPagination();
    }

    private JToolBar buildToolbar(HashMap actions) {
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        Object[] cats = actions.keySet().toArray(new ActionCategory[actions.size()]);
        Arrays.sort(cats);
        for (int i = 0; i < cats.length; ++i) {
            Object cat = cats[i];
            ActionPlugin[] plugins = (ActionPlugin[])actions.get(cat);
            PreviewPaneUtilities.addActionsToToolBar(toolBar, plugins, this);
        }
        return toolBar;
    }

    private void closeToolbar() {
        Window w;
        if (this.toolBar.getParent() != this.toolbarHolder && (w = SwingUtilities.windowForComponent(this.toolBar)) != null) {
            w.setVisible(false);
            w.dispose();
        }
        this.toolBar.setVisible(false);
    }

    public SwingGuiContext getSwingGuiContext() {
        return this.swingGuiContext;
    }

    public KeyedComboBoxModel getZoomModel() {
        return this.zoomModel;
    }

    private String formatZoomText(double zoom) {
        NumberFormat numberFormat = NumberFormat.getPercentInstance(this.swingGuiContext.getLocale());
        return numberFormat.format(zoom);
    }

    private void buildMenu(HashMap actions) {
        HashMap<ActionCategory, JMenu> menus = new HashMap<ActionCategory, JMenu>();
        int userPos = this.getUserDefinedCategoryPosition();
        ActionCategory[] categories = new ActionCategory[actions.size()];
        boolean insertedUserDefinedActions = false;
        int catCount = 0;
        Iterator iterator = actions.entrySet().iterator();
        while (iterator.hasNext()) {
            ActionCategory cat;
            Map.Entry entry = iterator.next();
            categories[catCount] = cat = (ActionCategory)entry.getKey();
            ++catCount;
            ActionPlugin[] plugins = (ActionPlugin[])entry.getValue();
            if (!insertedUserDefinedActions && cat.getPosition() > userPos) {
                ReportController controller = this.getReportController();
                if (controller != null) {
                    controller.initialize(this);
                    JMenu[] controlerMenus = controller.getMenus();
                    for (int i = 0; i < controlerMenus.length; ++i) {
                        ActionCategory userCategory = new ActionCategory();
                        userCategory.setName("X-User-Category-" + i);
                        userCategory.setPosition(userPos + i);
                        menus.put(userCategory, controlerMenus[i]);
                    }
                }
                insertedUserDefinedActions = true;
            }
            JMenu menu = PreviewPaneUtilities.createMenu(cat);
            int count = PreviewPaneUtilities.buildMenu(menu, plugins, this);
            menus.put(cat, menu);
        }
        CategoryTreeItem[] categoryTreeItems = PreviewPaneUtilities.buildMenuTree(categories);
        ArrayList<CategoryTreeItem> menuList = new ArrayList<CategoryTreeItem>();
        for (int i = 0; i < categoryTreeItems.length; ++i) {
            CategoryTreeItem item = categoryTreeItems[i];
            JMenu menu = (JMenu)menus.get(item.getCategory());
            Object[] childs = item.getChilds();
            Arrays.sort(childs);
            for (int j = 0; j < childs.length; ++j) {
                Object child = childs[j];
                JMenu childMenu = (JMenu)menus.get(((CategoryTreeItem)child).getCategory());
                if (childMenu == null) continue;
                menu.add(childMenu);
            }
            if (item.getParent() != null) continue;
            menuList.add(item);
        }
        Collections.sort(menuList);
        ArrayList<JMenu> retval = new ArrayList<JMenu>();
        for (int i = 0; i < menuList.size(); ++i) {
            CategoryTreeItem item = (CategoryTreeItem)menuList.get(i);
            JMenu menu = (JMenu)menus.get(item.getCategory());
            if (menu.getItemCount() <= 0) continue;
            retval.add(menu);
        }
        this.setMenu(retval.toArray(new JMenu[retval.size()]));
    }

    protected void initializeWithoutJob() {
        Configuration globalConfig = JFreeReportBoot.getInstance().getGlobalConfig();
        this.setIconTheme(PreviewPaneUtilities.createIconTheme(globalConfig));
        this.zoomModel.clear();
        for (int i = 0; i < ZOOM_FACTORS.length; ++i) {
            this.zoomModel.add((Object)new Double(ZOOM_FACTORS[i]), (Object)this.formatZoomText(ZOOM_FACTORS[i]));
        }
        this.zoom = ZOOM_FACTORS[2];
        this.zoomModel.setSelectedKey((Object)new Double(ZOOM_FACTORS[2]));
        HashMap actions = PreviewPaneUtilities.loadActions(this.swingGuiContext);
        this.buildMenu(actions);
        if (this.toolBar != null) {
            this.toolbarHolder.remove(this.toolBar);
        }
        this.toolBar = this.buildToolbar(actions);
        if (this.toolBar != null) {
            this.toolbarHolder.add((Component)this.toolBar, "North");
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        String oldTitle = this.title;
        this.title = title;
        this.firePropertyChange(TITLE_PROPERTY, oldTitle, title);
    }

    public double[] getZoomFactors() {
        return (double[])ZOOM_FACTORS.clone();
    }

    public boolean isPaginating() {
        return this.paginating;
    }

    public void setPaginating(boolean paginating) {
        boolean oldPaginating = this.paginating;
        this.paginating = paginating;
        this.firePropertyChange(PAGINATING_PROPERTY, oldPaginating, paginating);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void startPagination() {
        if (this.paginationWorker != null) {
            Worker worker = this.paginationWorker;
            synchronized (worker) {
                this.paginationWorker.finish();
            }
            this.paginationWorker = null;
        }
        if (this.printReportProcessor != null) {
            this.printReportProcessor.close();
            this.printReportProcessor = null;
        }
        ReportJob reportJob = this.getReportJob();
        this.printReportProcessor = new PrintReportProcessor(reportJob.derive());
        this.paginationWorker = new Worker();
        this.paginationWorker.setWorkload(new RepaginationRunnable(this.printReportProcessor));
    }

    public Drawable getNoReportDrawable() {
        return this.noReportDrawable;
    }

    public void setNoReportDrawable(Drawable noReportDrawable) {
        this.noReportDrawable = noReportDrawable;
    }

    public Drawable getPaginatingDrawable() {
        return this.paginatingDrawable;
    }

    public void setPaginatingDrawable(Drawable paginatingDrawable) {
        this.paginatingDrawable = paginatingDrawable;
    }

    protected void updateVisiblePage(int pageNumber) {
        if (this.printReportProcessor == null) {
            throw new IllegalStateException();
        }
        int pageIndex = this.getPageNumber() - 1;
        if (pageIndex < 0 || pageIndex >= this.printReportProcessor.getNumberOfPages()) {
            this.drawablePanel.setDrawable(null);
            this.pageDrawable.setBackend(null);
        } else {
            PageDrawable drawable = this.printReportProcessor.getPageDrawable(pageIndex);
            Log.debug((Object)("Drawable: " + drawable));
            this.pageDrawable.setBackend(drawable);
            this.drawablePanel.setDrawable((Drawable)this.pageDrawable);
        }
    }

    private class UpdateZoomHandler
    implements PropertyChangeListener {
        private UpdateZoomHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (!PreviewPane.ZOOM_PROPERTY.equals(evt.getPropertyName())) {
                return;
            }
            Log.debug((Object)("Zooming: " + PreviewPane.this.zoom));
            if (PreviewPane.this.zoom == 1.0) {
                Log.debug((Object)"JERE");
            }
            double zoom = PreviewPane.this.getZoom();
            PreviewPane.this.pageDrawable.setZoom(zoom);
            PreviewPane.this.zoomModel.setSelectedKey((Object)new Double(zoom));
            if (PreviewPane.this.zoomModel.getSelectedKey() == null) {
                Log.debug((Object)("Zooming: (2) " + zoom));
                PreviewPane.this.zoomModel.setSelectedItem((Object)PreviewPane.this.formatZoomText(zoom));
            }
            PreviewPane.this.drawablePanel.revalidate();
        }
    }

    private class PreviewUpdateHandler
    implements PropertyChangeListener {
        private PreviewUpdateHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if (PreviewPane.PAGINATING_PROPERTY.equals(propertyName)) {
                if (PreviewPane.this.isPaginating()) {
                    PreviewPane.this.drawablePanel.setDrawable(PreviewPane.this.getPaginatingDrawable());
                } else {
                    PreviewPane.this.updateVisiblePage(PreviewPane.this.getPageNumber());
                }
            } else if (PreviewPane.REPORT_JOB_PROPERTY.equals(propertyName)) {
                if (PreviewPane.this.getReportJob() == null) {
                    PreviewPane.this.drawablePanel.setDrawable(PreviewPane.this.getNoReportDrawable());
                }
            } else if (PreviewPane.PAGE_NUMBER_PROPERTY.equals(propertyName)) {
                if (PreviewPane.this.isPaginating()) {
                    return;
                }
                PreviewPane.this.updateVisiblePage(PreviewPane.this.getPageNumber());
            }
        }
    }

    private class UpdatePaginatingPropertyHandler
    implements Runnable {
        private boolean paginating;
        private int pageCount;
        private PrintReportProcessor processor;

        private UpdatePaginatingPropertyHandler(PrintReportProcessor processor, boolean paginating, int pageCount) {
            this.processor = processor;
            this.paginating = paginating;
            this.pageCount = pageCount;
        }

        public void run() {
            if (this.processor != PreviewPane.this.getPrintReportProcessor()) {
                Log.debug((Object)"No longer valid");
                return;
            }
            Log.debug((Object)("Pagination: " + this.paginating + " No. " + this.pageCount));
            if (!this.paginating) {
                PreviewPane.this.setNumberOfPages(this.pageCount);
                if (PreviewPane.this.getPageNumber() < 1) {
                    PreviewPane.this.setPageNumber(1);
                } else if (PreviewPane.this.getPageNumber() > this.pageCount) {
                    PreviewPane.this.setPageNumber(this.pageCount);
                }
            }
            PreviewPane.this.setPaginating(this.paginating);
        }
    }

    private class RepaginationRunnable
    implements Runnable {
        private PrintReportProcessor processor;

        private RepaginationRunnable(PrintReportProcessor processor) {
            this.processor = processor;
        }

        public void run() {
            UpdatePaginatingPropertyHandler startPaginationNotify = new UpdatePaginatingPropertyHandler(this.processor, true, 0);
            if (SwingUtilities.isEventDispatchThread()) {
                startPaginationNotify.run();
            } else {
                SwingUtilities.invokeLater(startPaginationNotify);
            }
            int pageCount = this.processor.getNumberOfPages();
            UpdatePaginatingPropertyHandler endPaginationNotify = new UpdatePaginatingPropertyHandler(this.processor, false, pageCount);
            if (SwingUtilities.isEventDispatchThread()) {
                endPaginationNotify.run();
            } else {
                SwingUtilities.invokeLater(endPaginationNotify);
            }
        }
    }

    private class PreviewGuiContext
    implements SwingGuiContext {
        private PreviewGuiContext() {
        }

        public Window getWindow() {
            return SwingUtil.getWindowAncestor(PreviewPane.this);
        }

        public Locale getLocale() {
            ReportJob report = PreviewPane.this.getReportJob();
            if (report != null) {
                return report.getReportStructureRoot().getLocale();
            }
            return Locale.getDefault();
        }

        public IconTheme getIconTheme() {
            return PreviewPane.this.getIconTheme();
        }

        public Configuration getConfiguration() {
            ReportJob report = PreviewPane.this.getReportJob();
            if (report != null) {
                return report.getConfiguration();
            }
            return JFreeReportBoot.getInstance().getGlobalConfig();
        }
    }
}

