/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.swing.preview;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import javax.swing.UIManager;
import org.jfree.layouting.modules.output.graphics.PageDrawable;
import org.jfree.ui.ExtendedDrawable;

public class PageBackgroundDrawable
implements ExtendedDrawable {
    private PageDrawable backend;
    private boolean borderPainted = false;
    private float shadowSize = 6.0f;
    private double zoom = 1.0;

    public PageDrawable getBackend() {
        return this.backend;
    }

    public void setBackend(PageDrawable backend) {
        this.backend = backend;
    }

    public boolean isBorderPainted() {
        return this.borderPainted;
    }

    public void setBorderPainted(boolean borderPainted) {
        this.borderPainted = borderPainted;
    }

    public double getZoom() {
        return this.zoom;
    }

    public void setZoom(double zoom) {
        this.zoom = zoom;
    }

    public Dimension getPreferredSize() {
        if (this.backend == null) {
            return new Dimension(0, 0);
        }
        Dimension preferredSize = this.backend.getPreferredSize();
        return new Dimension((int)((double)((float)preferredSize.width + this.shadowSize) * this.zoom), (int)((double)((float)preferredSize.height + this.shadowSize) * this.zoom));
    }

    public boolean isPreserveAspectRatio() {
        return true;
    }

    public float getShadowSize() {
        return this.shadowSize;
    }

    public void setShadowSize(float shadowSize) {
        this.shadowSize = shadowSize;
    }

    public void draw(Graphics2D g2, Rectangle2D area) {
        if (this.backend == null) {
            return;
        }
        PageFormat pageFormat = this.backend.getPageFormat();
        float outerW = (float)pageFormat.getWidth();
        float outerH = (float)pageFormat.getHeight();
        float innerX = (float)pageFormat.getImageableX();
        float innerY = (float)pageFormat.getImageableY();
        float innerW = (float)pageFormat.getImageableWidth();
        float innerH = (float)pageFormat.getImageableHeight();
        g2.transform(AffineTransform.getScaleInstance(this.getZoom(), this.getZoom()));
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        Rectangle2D.Float pageArea = new Rectangle2D.Float(0.0f, 0.0f, outerW, outerH);
        g2.setPaint(Color.white);
        g2.fill(pageArea);
        Graphics2D g22 = (Graphics2D)g2.create();
        this.backend.draw(g22, (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, pageFormat.getImageableWidth(), pageFormat.getImageableHeight()));
        g22.dispose();
        Rectangle2D.Float printingArea = new Rectangle2D.Float(innerX, innerY, innerW, innerH);
        Rectangle2D.Float southborder = new Rectangle2D.Float(this.getShadowSize(), outerH, outerW, this.getShadowSize());
        g2.setPaint(UIManager.getColor("controlShadow"));
        g2.fill(southborder);
        Rectangle2D.Float eastborder = new Rectangle2D.Float(outerW, this.getShadowSize(), this.getShadowSize(), outerH);
        g2.fill(eastborder);
        Rectangle2D.Float transPageArea = new Rectangle2D.Float(0.0f, 0.0f, outerW, outerH);
        g2.setPaint(Color.black);
        g2.draw(transPageArea);
        if (this.isBorderPainted()) {
            g2.setPaint(Color.gray);
            g2.draw(printingArea);
        }
    }
}

