/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.swing.html;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.jfree.base.config.ModifiableConfiguration;
import org.jfree.io.IOUtils;
import org.jfree.layouting.modules.output.html.FlowHtmlOutputProcessor;
import org.jfree.layouting.modules.output.html.HtmlOutputProcessor;
import org.jfree.layouting.modules.output.html.HtmlPrinter;
import org.jfree.layouting.modules.output.html.PageableHtmlOutputProcessor;
import org.jfree.layouting.modules.output.html.StreamingHtmlOutputProcessor;
import org.jfree.layouting.output.OutputProcessor;
import org.jfree.report.ReportConfigurationException;
import org.jfree.report.flow.ReportJob;
import org.jfree.report.flow.streaming.StreamingReportProcessor;
import org.jfree.repository.ContentLocation;
import org.jfree.repository.DefaultNameGenerator;
import org.jfree.repository.NameGenerator;
import org.jfree.repository.Repository;
import org.jfree.repository.RepositoryUtilities;
import org.jfree.repository.zipwriter.ZipRepository;
import org.jfree.util.Configuration;
import org.jfree.util.Log;

public class HtmlZipExportTask
implements Runnable {
    private ReportJob job;
    private String dataDirectory;
    private String exportMethod;
    private String filename;
    private File targetFile;
    private String encoding;

    public HtmlZipExportTask(ReportJob job) throws ReportConfigurationException {
        if (job == null) {
            throw new NullPointerException();
        }
        this.job = job;
        ModifiableConfiguration config = job.getConfiguration();
        this.dataDirectory = config.getConfigProperty("org.jfree.report.modules.gui.common.html.zip.DataDirectory");
        String targetFileName = config.getConfigProperty("org.jfree.report.modules.gui.common.html.zip.TargetFileName");
        this.exportMethod = config.getConfigProperty("org.jfree.report.modules.gui.common.html.zip.ExportMethod");
        this.encoding = config.getConfigProperty("org.jfree.report.modules.gui.common.html.zip.Encoding", "ASCII");
        this.targetFile = new File(targetFileName);
        this.filename = IOUtils.getInstance().stripFileExtension(this.targetFile.getName());
        if (this.targetFile.exists() && !this.targetFile.delete()) {
            throw new ReportConfigurationException("Target-File exists, but cannot be removed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        BufferedOutputStream fout = null;
        try {
            fout = new BufferedOutputStream(new FileOutputStream(this.targetFile));
            ZipRepository zipRepository = new ZipRepository((OutputStream)fout);
            ContentLocation root = zipRepository.getRoot();
            ContentLocation data = RepositoryUtilities.createLocation((Repository)zipRepository, (String[])RepositoryUtilities.split((String)this.dataDirectory, (String)"/"));
            StreamingReportProcessor sp = new StreamingReportProcessor();
            HtmlOutputProcessor outputProcessor = this.createOutputProcessor();
            HtmlPrinter printer = outputProcessor.getPrinter();
            printer.setContentWriter(root, (NameGenerator)new DefaultNameGenerator(root, this.filename));
            printer.setDataWriter(data, (NameGenerator)new DefaultNameGenerator(data, "content"));
            printer.setEncoding(this.encoding);
            sp.setOutputProcessor((OutputProcessor)outputProcessor);
            sp.processReport(this.job);
        }
        catch (Exception e) {
            Log.error((Object)"ZIP-Export failed. ", (Exception)e);
        }
        finally {
            try {
                this.job.close();
                this.job = null;
            }
            catch (Exception e) {}
            if (fout != null) {
                try {
                    ((OutputStream)fout).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected HtmlOutputProcessor createOutputProcessor() {
        if ("pageable".equals(this.exportMethod)) {
            return new PageableHtmlOutputProcessor((Configuration)this.job.getConfiguration());
        }
        if ("flow".equals(this.exportMethod)) {
            return new FlowHtmlOutputProcessor((Configuration)this.job.getConfiguration());
        }
        return new StreamingHtmlOutputProcessor((Configuration)this.job.getConfiguration());
    }
}

