/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.swing.html;

import java.io.File;
import org.jfree.base.config.ModifiableConfiguration;
import org.jfree.io.IOUtils;
import org.jfree.layouting.modules.output.html.FileSystemURLRewriter;
import org.jfree.layouting.modules.output.html.FlowHtmlOutputProcessor;
import org.jfree.layouting.modules.output.html.HtmlOutputProcessor;
import org.jfree.layouting.modules.output.html.HtmlPrinter;
import org.jfree.layouting.modules.output.html.PageableHtmlOutputProcessor;
import org.jfree.layouting.modules.output.html.StreamingHtmlOutputProcessor;
import org.jfree.layouting.modules.output.html.URLRewriter;
import org.jfree.layouting.output.OutputProcessor;
import org.jfree.report.ReportConfigurationException;
import org.jfree.report.flow.ReportJob;
import org.jfree.report.flow.streaming.StreamingReportProcessor;
import org.jfree.repository.ContentLocation;
import org.jfree.repository.DefaultNameGenerator;
import org.jfree.repository.NameGenerator;
import org.jfree.repository.file.FileRepository;
import org.jfree.util.Configuration;
import org.jfree.util.Log;

public class HtmlFileExportTask
implements Runnable {
    private ReportJob job;
    private File dataDirectory;
    private File targetDirectory;
    private String exportMethod;
    private String suffix;
    private String filename;
    private String encoding;

    public HtmlFileExportTask(ReportJob job) throws ReportConfigurationException {
        if (job == null) {
            throw new NullPointerException();
        }
        this.job = job;
        ModifiableConfiguration config = job.getConfiguration();
        String dataDirectoryName = config.getConfigProperty("org.jfree.report.modules.gui.common.html.file.DataDirectory");
        String targetFileName = config.getConfigProperty("org.jfree.report.modules.gui.common.html.file.TargetFileName");
        this.exportMethod = config.getConfigProperty("org.jfree.report.modules.gui.common.html.file.ExportMethod");
        this.encoding = config.getConfigProperty("org.jfree.report.modules.gui.common.html.file.Encoding", "ASCII");
        File targetFile = new File(targetFileName);
        this.targetDirectory = targetFile.getParentFile();
        this.dataDirectory = new File(targetFile, dataDirectoryName);
        if (!this.dataDirectory.isDirectory()) {
            throw new ReportConfigurationException("DataDirectory is invalid: " + this.dataDirectory);
        }
        this.suffix = IOUtils.getInstance().getFileExtension(targetFile.getName());
        this.filename = IOUtils.getInstance().stripFileExtension(targetFile.getName());
        if (targetFile.exists() && !targetFile.delete()) {
            throw new ReportConfigurationException("Target-File exists, but cannot be removed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            FileRepository targetRepository = new FileRepository(this.targetDirectory);
            ContentLocation targetRoot = targetRepository.getRoot();
            FileRepository dataRepository = new FileRepository(this.dataDirectory);
            ContentLocation dataRoot = dataRepository.getRoot();
            StreamingReportProcessor sp = new StreamingReportProcessor();
            HtmlOutputProcessor outputProcessor = this.createOutputProcessor();
            HtmlPrinter printer = outputProcessor.getPrinter();
            printer.setContentWriter(targetRoot, (NameGenerator)new DefaultNameGenerator(targetRoot, this.filename, this.suffix));
            printer.setDataWriter(dataRoot, (NameGenerator)new DefaultNameGenerator(dataRoot, "content"));
            printer.setEncoding(this.encoding);
            printer.setUrlRewriter((URLRewriter)new FileSystemURLRewriter());
            sp.setOutputProcessor((OutputProcessor)outputProcessor);
            sp.processReport(this.job);
        }
        catch (Exception e) {
            Log.error((Object)"File-Export failed. ", (Exception)e);
        }
        finally {
            try {
                this.job.close();
                this.job = null;
            }
            catch (Exception exception) {}
        }
    }

    protected HtmlOutputProcessor createOutputProcessor() {
        if ("pageable".equals(this.exportMethod)) {
            return new PageableHtmlOutputProcessor((Configuration)this.job.getConfiguration());
        }
        if ("flow".equals(this.exportMethod)) {
            return new FlowHtmlOutputProcessor((Configuration)this.job.getConfiguration());
        }
        return new StreamingHtmlOutputProcessor((Configuration)this.job.getConfiguration());
    }
}

