/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.swing.common;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.jfree.report.modules.gui.common.DefaultIconTheme;
import org.jfree.report.modules.gui.common.IconTheme;

public class JStatusBar
extends JComponent {
    public static final int TYPE_ERROR = 3;
    public static final int TYPE_WARNING = 2;
    public static final int TYPE_INFORMATION = 1;
    public static final int TYPE_NONE = 0;
    private JComponent otherComponents;
    private JLabel statusHolder;
    private IconTheme iconTheme;
    private int statusType;

    public JStatusBar() {
        this(new DefaultIconTheme());
    }

    public JStatusBar(IconTheme theme) {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getDefaults().getColor("controlShadow")));
        this.statusHolder = new JLabel(" ");
        this.statusHolder.setMinimumSize(new Dimension(0, 20));
        this.add((Component)this.statusHolder, "Center");
        this.otherComponents = new JPanel();
        this.add((Component)this.otherComponents, "East");
        this.iconTheme = theme;
    }

    protected IconTheme getIconTheme() {
        return this.iconTheme;
    }

    public void setIconTheme(IconTheme iconTheme) {
        IconTheme oldTheme = this.iconTheme;
        this.iconTheme = iconTheme;
        this.firePropertyChange("iconTheme", oldTheme, iconTheme);
        if (iconTheme == null) {
            this.statusHolder.setIcon(null);
        } else {
            this.updateTypeIcon(this.getStatusType());
        }
    }

    public JComponent getExtensionArea() {
        return this.otherComponents;
    }

    public int getStatusType() {
        return this.statusType;
    }

    public String getStatusText() {
        return this.statusHolder.getText();
    }

    public void setStatusText(String text) {
        String oldText = this.statusHolder.getText();
        this.statusHolder.setText(text);
        this.firePropertyChange("statusText", oldText, text);
    }

    public void setStatusType(int type) {
        int oldType = this.statusType;
        this.statusType = type;
        this.firePropertyChange("statusType", oldType, type);
        this.updateTypeIcon(type);
    }

    public void setStatus(int type, String text) {
        this.statusType = type;
        this.updateTypeIcon(type);
        this.statusHolder.setText(text);
    }

    private void updateTypeIcon(int type) {
        if (this.iconTheme != null) {
            if (type == 3) {
                Icon res = this.getIconTheme().getSmallIcon(this.getLocale(), "statusbar.errorIcon");
                this.statusHolder.setIcon(res);
            } else if (type == 2) {
                Icon res = this.getIconTheme().getSmallIcon(this.getLocale(), "statusbar.warningIcon");
                this.statusHolder.setIcon(res);
            } else if (type == 1) {
                Icon res = this.getIconTheme().getSmallIcon(this.getLocale(), "statusbar.informationIcon");
                this.statusHolder.setIcon(res);
            } else {
                Icon res = this.getIconTheme().getSmallIcon(this.getLocale(), "statusbar.otherIcon");
                this.statusHolder.setIcon(res);
            }
        }
    }

    public void clear() {
        this.setStatus(0, " ");
    }

    public Locale getLocale() {
        try {
            return super.getLocale();
        }
        catch (IllegalComponentStateException ice) {
            return Locale.getDefault();
        }
    }
}

