/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.swing.common;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public abstract class FormValidator {
    private FormTextfieldListener formTextfieldListener = new FormTextfieldListener();
    private FormActionListener actionListener = new FormActionListener();
    private static final String DOCUMENT_PROPERTY_NAME = "document";
    private FormItemListener itemListener = new FormItemListener();
    private boolean enabled;

    protected FormValidator() {
    }

    public void registerTextField(JTextComponent textField) {
        textField.getDocument().addDocumentListener(this.formTextfieldListener);
        textField.addPropertyChangeListener(DOCUMENT_PROPERTY_NAME, this.formTextfieldListener);
    }

    public void registerButton(AbstractButton bt) {
        bt.addActionListener(this.actionListener);
    }

    public void registerComboBox(JComboBox bt) {
        bt.addItemListener(this.itemListener);
    }

    public abstract Action getConfirmAction();

    protected final void handleValidate() {
        Action confirmAction = this.getConfirmAction();
        if (confirmAction == null || !this.enabled) {
            return;
        }
        if (!this.performValidate()) {
            confirmAction.setEnabled(false);
        } else {
            confirmAction.setEnabled(true);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public abstract boolean performValidate();

    private class FormItemListener
    implements ItemListener {
        private FormItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            FormValidator.this.handleValidate();
        }
    }

    private class FormActionListener
    implements ActionListener {
        private FormActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            FormValidator.this.handleValidate();
        }
    }

    private class FormTextfieldListener
    implements DocumentListener,
    PropertyChangeListener {
        private FormTextfieldListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (FormValidator.DOCUMENT_PROPERTY_NAME.equals(evt.getPropertyName())) {
                Document olddoc = (Document)evt.getOldValue();
                olddoc.removeDocumentListener(this);
                Document newdoc = (Document)evt.getOldValue();
                newdoc.addDocumentListener(this);
            }
        }

        public void changedUpdate(DocumentEvent e) {
            FormValidator.this.handleValidate();
        }

        public void insertUpdate(DocumentEvent e) {
            FormValidator.this.handleValidate();
        }

        public void removeUpdate(DocumentEvent e) {
            FormValidator.this.handleValidate();
        }
    }
}

