/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.swing.common;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JDialog;
import org.jfree.base.config.ModifiableConfiguration;
import org.jfree.report.flow.ReportJob;
import org.jfree.report.modules.gui.common.GuiContext;
import org.jfree.report.modules.gui.swing.common.ExportDialog;
import org.jfree.report.modules.gui.swing.common.FormValidator;
import org.jfree.report.modules.gui.swing.common.JStatusBar;
import org.jfree.report.modules.preferences.base.ConfigFactory;
import org.jfree.report.modules.preferences.base.ConfigStorage;
import org.jfree.report.modules.preferences.base.ConfigStoreException;
import org.jfree.util.Configuration;
import org.jfree.util.Log;

public abstract class AbstractExportDialog
extends JDialog
implements ExportDialog {
    private Action cancelAction;
    private Action confirmAction;
    private FormValidator formValidator;
    private ResourceBundle resources;
    private boolean confirmed;
    private ReportJob reportJob;
    private GuiContext guiContext;

    public AbstractExportDialog() {
        this.initialize();
    }

    public AbstractExportDialog(Frame owner) {
        super(owner);
        this.initialize();
    }

    public AbstractExportDialog(Dialog owner) {
        super(owner);
        this.initialize();
    }

    private void initialize() {
        ResourceBundle resources = ResourceBundle.getBundle("org.jfree.report.modules.gui.swing.common.resources");
        this.cancelAction = new CancelAction(resources);
        this.confirmAction = new ConfirmAction(resources);
        this.formValidator = new ExportDialogValidator();
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowCloseHandler());
    }

    public abstract JStatusBar getStatusBar();

    protected Action getCancelAction() {
        return this.cancelAction;
    }

    protected void setCancelAction(Action cancelAction) {
        this.cancelAction = cancelAction;
    }

    protected Action getConfirmAction() {
        return this.confirmAction;
    }

    protected void setConfirmAction(Action confirmAction) {
        this.confirmAction = confirmAction;
    }

    protected abstract boolean performValidate();

    protected FormValidator getFormValidator() {
        return this.formValidator;
    }

    protected abstract void initializeFromJob(ReportJob var1, GuiContext var2);

    protected ReportJob getReportJob() {
        return this.reportJob;
    }

    protected GuiContext getGuiContext() {
        return this.guiContext;
    }

    public boolean performQueryForExport(ReportJob reportJob, GuiContext guiContext) {
        this.reportJob = reportJob;
        this.guiContext = guiContext;
        Locale locale = reportJob.getReportStructureRoot().getLocale();
        this.setLocale(locale);
        this.pack();
        this.clear();
        this.initializeFromJob(reportJob, guiContext);
        FormValidator formValidator = this.getFormValidator();
        formValidator.setEnabled(false);
        ModifiableConfiguration repConf = reportJob.getConfiguration();
        boolean inputStorageEnabled = this.isInputStorageEnabled((Configuration)repConf);
        Object loadedConfiguration = inputStorageEnabled ? this.loadFromConfigStore(reportJob, (Configuration)repConf) : repConf;
        this.setDialogContents((Configuration)loadedConfiguration);
        formValidator.setEnabled(true);
        formValidator.handleValidate();
        this.setModal(true);
        this.setVisible(true);
        if (!this.isConfirmed()) {
            return false;
        }
        formValidator.setEnabled(false);
        Configuration fullDialogContents = this.grabDialogContents(true);
        Enumeration configProperties = fullDialogContents.getConfigProperties();
        while (configProperties.hasMoreElements()) {
            String key = (String)configProperties.nextElement();
            repConf.setConfigProperty(key, fullDialogContents.getConfigProperty(key));
        }
        if (inputStorageEnabled) {
            this.saveToConfigStore(reportJob, (Configuration)repConf);
        }
        formValidator.setEnabled(true);
        this.reportJob = null;
        return true;
    }

    private void saveToConfigStore(ReportJob reportJob, Configuration reportConfiguration) {
        String configPath = ConfigFactory.encodePath(reportJob.getName() + this.getConfigurationSuffix());
        try {
            boolean fullStorageEnabled = this.isFullInputStorageEnabled(reportConfiguration);
            Configuration dialogContents = this.grabDialogContents(fullStorageEnabled);
            ConfigStorage storage = ConfigFactory.getInstance().getUserStorage();
            storage.store(configPath, dialogContents);
        }
        catch (ConfigStoreException cse) {
            Log.debug((Object)("Unable to store the defaults in Export export dialog. [" + this.getClass() + "]"));
        }
    }

    private Configuration loadFromConfigStore(ReportJob reportJob, Configuration defaultConfig) {
        String configPath = ConfigFactory.encodePath(reportJob.getName() + this.getConfigurationSuffix());
        ConfigStorage storage = ConfigFactory.getInstance().getUserStorage();
        try {
            return storage.load(configPath, defaultConfig);
        }
        catch (Exception cse) {
            Log.debug((Object)("Unable to load the defaults in Export export dialog. [" + this.getClass() + "]"));
            return defaultConfig;
        }
    }

    protected abstract String getConfigurationPrefix();

    protected abstract Configuration grabDialogContents(boolean var1);

    protected abstract void setDialogContents(Configuration var1);

    protected abstract String getConfigurationSuffix();

    protected ResourceBundle getResources() {
        if (this.resources == null) {
            this.resources = ResourceBundle.getBundle(this.getResourceBaseName());
        }
        return this.resources;
    }

    protected boolean isInputStorageEnabled(Configuration config) {
        String confVal = config.getConfigProperty(this.getConfigurationPrefix() + "StoreDialogContents");
        return !"none".equalsIgnoreCase(confVal);
    }

    protected boolean isFullInputStorageEnabled(Configuration config) {
        String confVal = config.getConfigProperty(this.getConfigurationPrefix() + "StoreDialogContents");
        return "all".equalsIgnoreCase(confVal);
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    protected void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    protected boolean performConfirm() {
        return true;
    }

    public abstract void clear();

    protected abstract String getResourceBaseName();

    protected File resolvePath(String baseDirectory) {
        if (baseDirectory == null) {
            throw new IllegalArgumentException("The base directory must not be null");
        }
        if (!baseDirectory.startsWith("~/")) {
            return new File(baseDirectory);
        }
        String homeDirectory = System.getProperty("user.home");
        if ("~/".equals(baseDirectory)) {
            return new File(homeDirectory);
        }
        baseDirectory = baseDirectory.substring(2);
        return new File(homeDirectory, baseDirectory);
    }

    private class WindowCloseHandler
    extends WindowAdapter {
        private WindowCloseHandler() {
        }

        public void windowClosing(WindowEvent e) {
            Action cancelAction = AbstractExportDialog.this.getCancelAction();
            if (cancelAction != null) {
                cancelAction.actionPerformed(null);
            } else {
                AbstractExportDialog.this.setConfirmed(false);
                AbstractExportDialog.this.setVisible(false);
            }
        }
    }

    private class ExportDialogValidator
    extends FormValidator {
        private ExportDialogValidator() {
        }

        public boolean performValidate() {
            return AbstractExportDialog.this.performValidate();
        }

        public Action getConfirmAction() {
            return AbstractExportDialog.this.getConfirmAction();
        }
    }

    private class CancelAction
    extends AbstractAction {
        private CancelAction(ResourceBundle resources) {
            this.putValue("Name", resources.getString("OptionPane.cancelButtonText"));
        }

        public void actionPerformed(ActionEvent e) {
            AbstractExportDialog.this.setConfirmed(false);
            AbstractExportDialog.this.setVisible(false);
        }
    }

    private class ConfirmAction
    extends AbstractAction {
        private ConfirmAction(ResourceBundle resources) {
            this.putValue("Name", resources.getString("OptionPane.okButtonText"));
        }

        public void actionPerformed(ActionEvent e) {
            if (AbstractExportDialog.this.performValidate() && AbstractExportDialog.this.performConfirm()) {
                AbstractExportDialog.this.setConfirmed(true);
                AbstractExportDialog.this.setVisible(false);
            }
        }
    }
}

