/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.swing.common;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.jfree.report.modules.gui.common.IconTheme;
import org.jfree.report.modules.gui.swing.common.ActionPlugin;
import org.jfree.report.modules.gui.swing.common.ReportProgressDialog;
import org.jfree.report.modules.gui.swing.common.SwingGuiContext;
import org.jfree.util.ExtendedConfiguration;
import org.jfree.util.ExtendedConfigurationWrapper;
import org.jfree.util.ResourceBundleSupport;

public abstract class AbstractActionPlugin
implements ActionPlugin {
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private boolean enabled;
    private ResourceBundleSupport baseResources;
    private IconTheme iconTheme;
    private String statusText;
    public static final String BASE_RESOURCE_CLASS = "org.jfree.report.modules.gui.common.resources";
    private SwingGuiContext context;
    private ExtendedConfiguration configuration;

    protected AbstractActionPlugin() {
    }

    public boolean initialize(SwingGuiContext context) {
        this.context = context;
        this.baseResources = new ResourceBundleSupport(context.getLocale(), BASE_RESOURCE_CLASS);
        this.iconTheme = context.getIconTheme();
        this.configuration = new ExtendedConfigurationWrapper(context.getConfiguration());
        return true;
    }

    protected PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    public SwingGuiContext getContext() {
        return this.context;
    }

    public ExtendedConfiguration getConfig() {
        return this.configuration;
    }

    public boolean isSeparated() {
        return this.getConfig().getBoolProperty(this.getConfigurationPrefix() + "separated");
    }

    public String getFailureDescription() {
        return this.baseResources.formatMessage("statusline.export.generic-failure-description", (Object)this.getDisplayName());
    }

    public String getStatusText() {
        return this.statusText;
    }

    public void setStatusText(String statusText) {
        String oldText = this.statusText;
        this.statusText = statusText;
        this.propertyChangeSupport.firePropertyChange("statusText", oldText, statusText);
    }

    public boolean isAddToToolbar() {
        return this.getConfig().getBoolProperty(this.getConfigurationPrefix() + "add-to-toolbar");
    }

    public boolean isAddToMenu() {
        String name = this.getConfigurationPrefix() + "add-to-menu";
        return this.getConfig().getBoolProperty(name);
    }

    protected ReportProgressDialog createProgressDialog() {
        Window proxy = this.context.getWindow();
        if (proxy instanceof Frame) {
            return new ReportProgressDialog((Frame)proxy);
        }
        if (proxy instanceof Dialog) {
            return new ReportProgressDialog((Dialog)proxy);
        }
        return new ReportProgressDialog();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(property, l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public void setEnabled(boolean enabled) {
        boolean oldEnabled = this.enabled;
        this.enabled = enabled;
        this.propertyChangeSupport.firePropertyChange("enabled", oldEnabled, enabled);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public IconTheme getIconTheme() {
        return this.iconTheme;
    }

    protected abstract String getConfigurationPrefix();

    public int getMenuOrder() {
        return this.getConfig().getIntProperty(this.getConfigurationPrefix() + "menu-order", 0);
    }

    public int getToolbarOrder() {
        return this.getConfig().getIntProperty(this.getConfigurationPrefix() + "toolbar-order", 0);
    }

    public String getRole() {
        return this.getConfig().getConfigProperty(this.getConfigurationPrefix() + "role");
    }

    public int getRolePreference() {
        return this.getConfig().getIntProperty(this.getConfigurationPrefix() + "role-preference", 0);
    }
}

