/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.common;

import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Icon;
import org.jfree.report.JFreeReportBoot;
import org.jfree.report.modules.gui.common.IconTheme;
import org.jfree.util.Configuration;
import org.jfree.util.ResourceBundleSupport;

public class DefaultIconTheme
implements IconTheme {
    private String bundleName;

    public DefaultIconTheme() {
        this.initialize(JFreeReportBoot.getInstance().getGlobalConfig());
    }

    public void initialize(Configuration configuration) {
        this.bundleName = configuration.getConfigProperty("org.jfree.report.modules.gui.common.IconThemeBundle");
    }

    public Icon getSmallIcon(Locale locale, String id) {
        return this.getResourceBundleSupport(locale).getIcon(id, false);
    }

    public Icon getLargeIcon(Locale locale, String id) {
        return this.getResourceBundleSupport(locale).getIcon(id, true);
    }

    private ResourceBundleSupport getResourceBundleSupport(Locale locale) {
        if (this.bundleName == null) {
            throw new IllegalStateException("No resource-bundle. Did you boot the engine?");
        }
        return new ResourceBundleSupport(locale, ResourceBundle.getBundle(this.bundleName, locale));
    }
}

