/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.factories.report.flow;

import java.beans.IntrospectionException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.jfree.report.util.CharacterEntityParser;
import org.jfree.report.util.beans.BeanException;
import org.jfree.report.util.beans.BeanUtility;
import org.jfree.util.Log;
import org.jfree.util.ObjectUtilities;
import org.jfree.xmlns.parser.Base64;
import org.jfree.xmlns.parser.ParseException;
import org.jfree.xmlns.parser.PropertyReadHandler;
import org.jfree.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TypedPropertyReadHandler
extends PropertyReadHandler {
    private boolean plainContent;
    private String encoding;
    private String className;
    private BeanUtility beanUtility;
    private String expressionName;
    private CharacterEntityParser entityParser;
    static /* synthetic */ Class class$org$jfree$report$modules$factories$report$flow$TypedPropertyReadHandler;

    public TypedPropertyReadHandler(BeanUtility beanDescription, String expressionName, CharacterEntityParser entityParser) {
        if (beanDescription == null) {
            throw new NullPointerException("Expression must not be null");
        }
        if (entityParser == null) {
            throw new NullPointerException("EntityParser must not be null");
        }
        this.expressionName = expressionName;
        this.beanUtility = beanDescription;
        this.entityParser = entityParser;
        this.plainContent = true;
    }

    protected void doneParsing() throws SAXException {
        super.doneParsing();
        try {
            if (this.plainContent) {
                String result = this.getResult();
                if ("base64".equals(this.encoding)) {
                    byte[] data = Base64.decode((char[])result.trim().toCharArray());
                    ByteArrayInputStream bin = new ByteArrayInputStream(data);
                    ObjectInputStream oin = new ObjectInputStream(bin);
                    Object value = oin.readObject();
                    this.beanUtility.setProperty(this.getName(), value);
                } else if (this.className != null) {
                    ClassLoader cl = ObjectUtilities.getClassLoader((Class)(class$org$jfree$report$modules$factories$report$flow$TypedPropertyReadHandler == null ? (class$org$jfree$report$modules$factories$report$flow$TypedPropertyReadHandler = TypedPropertyReadHandler.class$("org.jfree.report.modules.factories.report.flow.TypedPropertyReadHandler")) : class$org$jfree$report$modules$factories$report$flow$TypedPropertyReadHandler));
                    Class<?> c = cl.loadClass(this.className);
                    this.beanUtility.setPropertyAsString(this.getName(), c, this.entityParser.decodeEntities(result));
                } else {
                    this.beanUtility.setPropertyAsString(this.getName(), this.entityParser.decodeEntities(result));
                }
            }
        }
        catch (BeanException e) {
            e.printStackTrace();
            throw new ParseException("Unable to assign property '" + this.getName() + "' to expression '" + this.expressionName + "'", (Exception)((Object)e), this.getLocator());
        }
        catch (ClassNotFoundException e) {
            throw new ParseException("Unable to assign property '" + this.getName() + "' to expression '" + this.expressionName + "'", (Exception)e, this.getLocator());
        }
        catch (IOException e) {
            throw new ParseException("Unable to assign property '" + this.getName() + "' to expression '" + this.expressionName + "'", (Exception)e, this.getLocator());
        }
    }

    protected void startParsing(Attributes attrs) throws SAXException {
        super.startParsing(attrs);
        this.className = attrs.getValue(this.getUri(), "class");
        this.encoding = attrs.getValue(this.getUri(), "encoding");
        if (this.encoding == null) {
            this.encoding = "text";
        } else if (!"text".equals(this.encoding) && !"base64".equals(this.encoding)) {
            Log.warn((Object)"Invalid value for attribute 'encoding'. Defaulting to 'text'");
            this.encoding = "text";
        }
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("property".equals(tagName)) {
            this.plainContent = false;
            String name = atts.getValue(uri, "name");
            if (name == null) {
                throw new ParseException("Required attribute 'name' is missing", this.getLocator());
            }
            try {
                Class type = this.beanUtility.getPropertyType(name);
                Object property = type.newInstance();
                BeanUtility propertyUtility = new BeanUtility(property);
                return new TypedPropertyReadHandler(propertyUtility, this.expressionName, this.entityParser);
            }
            catch (BeanException e) {
                throw new ParseException("Property '" + name + "' for expression '" + this.className + "' is not valid. The specified class was not found.", (Exception)((Object)e), this.getRootHandler().getDocumentLocator());
            }
            catch (IllegalAccessException e) {
                throw new ParseException("Property '" + name + "' for expression '" + this.className + "' is not valid. The specified class was not found.", (Exception)e, this.getRootHandler().getDocumentLocator());
            }
            catch (InstantiationException e) {
                throw new ParseException("Property '" + name + "' for expression '" + this.className + "' is not valid. The specified class cannot be instantiated.", (Exception)e, this.getRootHandler().getDocumentLocator());
            }
            catch (IntrospectionException e) {
                throw new ParseException("Property '" + name + "' for expression '" + this.className + "' is not valid. Introspection failed for this expression.", (Exception)e, this.getRootHandler().getDocumentLocator());
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

