/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.factories.report.flow;

import java.util.ArrayList;
import org.jfree.report.modules.factories.report.base.NodeReadHandler;
import org.jfree.report.modules.factories.report.base.NodeReadHandlerFactory;
import org.jfree.report.modules.factories.report.flow.AbstractElementReadHandler;
import org.jfree.report.modules.factories.report.flow.FlowOperationReadHandler;
import org.jfree.report.structure.Element;
import org.jfree.report.structure.Section;
import org.jfree.report.structure.StaticText;
import org.jfree.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SectionReadHandler
extends AbstractElementReadHandler {
    private Section section;
    private StringBuffer textBuffer;
    private ArrayList nodes = new ArrayList();
    private ArrayList operationsAfter = new ArrayList();
    private ArrayList operationsBefore = new ArrayList();
    private String repeat;

    public SectionReadHandler() {
    }

    public SectionReadHandler(Section section) {
        this();
        this.section = section;
    }

    protected Element getElement() {
        if (this.section == null) {
            this.section = new Section();
        }
        return this.section;
    }

    protected void startParsing(Attributes attrs) throws SAXException {
        super.startParsing(attrs);
        String repeatValue = attrs.getValue(this.getUri(), "repeat");
        if (repeatValue != null) {
            this.repeat = repeatValue;
        }
        if (!"http://jfreereport.sourceforge.net/namespaces/reports/flow".equals(this.getUri())) {
            Element element = this.getElement();
            int attrLength = attrs.getLength();
            for (int i = 0; i < attrLength; ++i) {
                String uri = attrs.getURI(i);
                String local = attrs.getLocalName(i);
                if ("http://jfreereport.sourceforge.net/namespaces/reports/flow".equals(uri)) continue;
                element.setAttribute(uri, local, attrs.getValue(i));
            }
        }
    }

    protected void configureElement(Element e) {
        super.configureElement(e);
        Section section = (Section)e;
        if (this.repeat != null) {
            section.setRepeat("true".equals(this.repeat));
        }
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        NodeReadHandlerFactory factory;
        NodeReadHandler handler;
        XmlReadHandler elementTypeHanders;
        if (this.textBuffer != null) {
            this.nodes.add(new StaticText(this.textBuffer.toString()));
            this.textBuffer = null;
        }
        if ((elementTypeHanders = super.getHandlerForChild(uri, tagName, atts)) != null) {
            return elementTypeHanders;
        }
        if ("http://jfreereport.sourceforge.net/namespaces/reports/flow".equals(uri)) {
            if ("operation-after".equals(tagName)) {
                FlowOperationReadHandler frh = new FlowOperationReadHandler();
                this.operationsAfter.add(frh);
                return frh;
            }
            if ("operation-before".equals(tagName)) {
                FlowOperationReadHandler frh = new FlowOperationReadHandler();
                this.operationsBefore.add(frh);
                return frh;
            }
        }
        if ((handler = (NodeReadHandler)(factory = NodeReadHandlerFactory.getInstance()).getHandler(uri, tagName)) != null) {
            this.nodes.add(handler);
            return handler;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        FlowOperationReadHandler handler;
        int i;
        if (this.textBuffer != null) {
            this.nodes.add(new StaticText(this.textBuffer.toString()));
            this.textBuffer = null;
        }
        Section section = (Section)this.getElement();
        this.configureElement(section);
        for (i = 0; i < this.nodes.size(); ++i) {
            Object wrapper = this.nodes.get(i);
            if (wrapper instanceof StaticText) {
                section.addNode((StaticText)wrapper);
                continue;
            }
            if (!(wrapper instanceof NodeReadHandler)) continue;
            NodeReadHandler nr = (NodeReadHandler)wrapper;
            section.addNode(nr.getNode());
        }
        for (i = 0; i < this.operationsAfter.size(); ++i) {
            handler = (FlowOperationReadHandler)((Object)this.operationsAfter.get(i));
            section.addOperationAfter(handler.getOperation());
        }
        for (i = 0; i < this.operationsBefore.size(); ++i) {
            handler = (FlowOperationReadHandler)((Object)this.operationsBefore.get(i));
            section.addOperationBefore(handler.getOperation());
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.textBuffer == null) {
            this.textBuffer = new StringBuffer();
        }
        this.textBuffer.append(ch, start, length);
    }
}

