/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.factories.data.sql;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.jfree.report.modules.data.sql.ConnectionProvider;
import org.jfree.report.modules.data.sql.DriverConnectionProvider;
import org.jfree.report.modules.factories.data.sql.ConnectionReadHandler;
import org.jfree.xmlns.parser.AbstractXmlReadHandler;
import org.jfree.xmlns.parser.PropertiesReadHandler;
import org.jfree.xmlns.parser.StringReadHandler;
import org.jfree.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DriverConnectionReadHandler
extends AbstractXmlReadHandler
implements ConnectionReadHandler {
    private StringReadHandler driverReadHandler;
    private StringReadHandler urlReadHandler;
    private PropertiesReadHandler propertiesReadHandler;
    private ConnectionProvider driverConnectionProvider;

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("driver".equals(tagName)) {
            this.driverReadHandler = new StringReadHandler();
            return this.driverReadHandler;
        }
        if ("url".equals(tagName)) {
            this.urlReadHandler = new StringReadHandler();
            return this.urlReadHandler;
        }
        if ("properties".equals(tagName)) {
            this.propertiesReadHandler = new PropertiesReadHandler();
            return this.propertiesReadHandler;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        DriverConnectionProvider provider = new DriverConnectionProvider();
        if (this.driverReadHandler != null) {
            provider.setDriver(this.driverReadHandler.getResult());
        }
        if (this.urlReadHandler != null) {
            provider.setUrl(this.urlReadHandler.getResult());
        }
        if (this.propertiesReadHandler != null) {
            Properties p = (Properties)this.propertiesReadHandler.getObject();
            Iterator<Map.Entry<Object, Object>> it = p.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Object, Object> entry = it.next();
                provider.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        this.driverConnectionProvider = provider;
    }

    public Object getObject() throws SAXException {
        return this.driverConnectionProvider;
    }

    public ConnectionProvider getProvider() {
        return this.driverConnectionProvider;
    }
}

