/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.data.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.jfree.report.DataSet;
import org.jfree.report.JFreeReportBoot;
import org.jfree.report.ReportData;
import org.jfree.report.ReportDataFactory;
import org.jfree.report.ReportDataFactoryException;
import org.jfree.report.TableReportData;
import org.jfree.report.modules.data.sql.ConnectionProvider;
import org.jfree.report.modules.data.sql.SQLParameterLookupParser;
import org.jfree.report.modules.data.sql.SQLReportData;
import org.jfree.report.modules.data.sql.StaticConnectionProvider;
import org.jfree.report.util.DataSetUtility;
import org.jfree.util.Configuration;

public class SimpleSQLReportDataFactory
implements ReportDataFactory,
Cloneable {
    private static final Object NULL_TOKEN = new Object();
    private HashMap preparedStatements;
    private Connection connection;
    private ConnectionProvider connectionProvider;
    private boolean labelMapping;
    private static final String COLUMN_NAME_MAPPING_KEY = "org.jfree.report.modules.data.sql.ColumnNameMapping";

    public SimpleSQLReportDataFactory(Connection connection) {
        this(new StaticConnectionProvider(connection));
    }

    public SimpleSQLReportDataFactory(ConnectionProvider connectionProvider) {
        if (connectionProvider == null) {
            throw new NullPointerException();
        }
        this.connectionProvider = connectionProvider;
        this.preparedStatements = new HashMap();
        Configuration globalConfig = JFreeReportBoot.getInstance().getGlobalConfig();
        this.labelMapping = "Label".equals(globalConfig.getConfigProperty(COLUMN_NAME_MAPPING_KEY, "Label"));
    }

    public boolean isLabelMapping() {
        return this.labelMapping;
    }

    public void setLabelMapping(boolean labelMapping) {
        this.labelMapping = labelMapping;
    }

    private synchronized Connection getConnection() throws SQLException {
        if (this.connection == null) {
            this.connection = this.connectionProvider.getConnection();
        }
        return this.connection;
    }

    private int getBestResultSetType() throws SQLException {
        Connection connection = this.getConnection();
        boolean supportsScrollInsensitive = connection.getMetaData().supportsResultSetType(1004);
        boolean supportsScrollSensitive = connection.getMetaData().supportsResultSetType(1005);
        if (supportsScrollInsensitive) {
            return 1004;
        }
        if (supportsScrollSensitive) {
            return 1005;
        }
        return 1003;
    }

    public synchronized ReportData queryData(String query, DataSet parameters) throws ReportDataFactoryException {
        try {
            PreparedStatementCarrier pstmtCarrier = (PreparedStatementCarrier)this.preparedStatements.get(query);
            if (pstmtCarrier == null) {
                SQLParameterLookupParser parser = new SQLParameterLookupParser();
                String translatedQuery = parser.translateAndLookup(query);
                PreparedStatement pstmt = this.getConnection().prepareStatement(translatedQuery, this.getBestResultSetType(), 1007);
                pstmtCarrier = new PreparedStatementCarrier(pstmt, parser.getFields());
                this.preparedStatements.put(query, pstmtCarrier);
            }
            PreparedStatement pstmt = pstmtCarrier.getPreparedStatement();
            pstmt.clearParameters();
            String[] params = pstmtCarrier.getParameters();
            for (int i = 0; i < params.length; ++i) {
                String param = params[i];
                Object pvalue = DataSetUtility.getByName(parameters, param, NULL_TOKEN);
                if (pvalue == NULL_TOKEN) {
                    throw new ReportDataFactoryException("Setting parameter '" + param + "' failed: No such column.");
                }
                if (pvalue == null) {
                    pstmt.setObject(i + 1, null);
                    continue;
                }
                pstmt.setObject(i + 1, pvalue);
            }
            ResultSet res = pstmt.executeQuery();
            int resultSetType = res.getType();
            if (resultSetType == 1003) {
                TableModel model = this.generateDefaultTableModel(res, this.labelMapping);
                res.close();
                return new TableReportData(model);
            }
            return new SQLReportData(res, this.labelMapping);
        }
        catch (ReportDataFactoryException rdfe) {
            throw rdfe;
        }
        catch (Exception e) {
            throw new ReportDataFactoryException("Failed at query: " + query, e);
        }
    }

    public void open() {
    }

    public synchronized void close() {
        if (this.connection == null) {
            return;
        }
        try {
            this.connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.connection = null;
    }

    private TableModel generateDefaultTableModel(ResultSet rs, boolean labelMapping) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int colcount = rsmd.getColumnCount();
        ArrayList<String> header = new ArrayList<String>(colcount);
        for (int i = 0; i < colcount; ++i) {
            String name;
            if (labelMapping) {
                name = rsmd.getColumnLabel(i + 1);
                header.add(name);
                continue;
            }
            name = rsmd.getColumnName(i + 1);
            header.add(name);
        }
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        while (rs.next()) {
            Object[] column = new Object[colcount];
            for (int i = 0; i < colcount; ++i) {
                column[i] = rs.getObject(i + 1);
                if (!rs.wasNull()) continue;
                column[i] = null;
            }
            rows.add(column);
        }
        Object[] tempRows = rows.toArray();
        Object[][] rowMap = new Object[tempRows.length][];
        for (int i = 0; i < tempRows.length; ++i) {
            rowMap[i] = (Object[])tempRows[i];
        }
        return new DefaultTableModel(rowMap, header.toArray());
    }

    public ReportDataFactory derive() {
        try {
            return (ReportDataFactory)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Clone failed?");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SimpleSQLReportDataFactory dataFactory = (SimpleSQLReportDataFactory)super.clone();
        dataFactory.connection = null;
        dataFactory.preparedStatements = (HashMap)this.preparedStatements.clone();
        dataFactory.preparedStatements.clear();
        return dataFactory;
    }

    private static class PreparedStatementCarrier {
        private PreparedStatement preparedStatement;
        private String[] parameters;

        private PreparedStatementCarrier(PreparedStatement preparedStatement, String[] parameters) {
            this.preparedStatement = preparedStatement;
            this.parameters = parameters;
        }

        public PreparedStatement getPreparedStatement() {
            return this.preparedStatement;
        }

        public String[] getParameters() {
            return this.parameters;
        }
    }
}

