/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.data.beans;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.swing.table.TableModel;
import org.jfree.report.DataSet;
import org.jfree.report.ReportData;
import org.jfree.report.ReportDataFactory;
import org.jfree.report.ReportDataFactoryException;
import org.jfree.report.TableReportData;
import org.jfree.report.util.CSVTokenizer;
import org.jfree.report.util.DataSetUtility;
import org.jfree.util.ObjectUtilities;

public class StaticReportDataFactory
implements ReportDataFactory {
    static /* synthetic */ Class class$org$jfree$report$modules$data$beans$StaticReportDataFactory;
    static /* synthetic */ Class class$javax$swing$table$TableModel;
    static /* synthetic */ Class class$org$jfree$report$ReportData;

    public ReportData queryData(String query, DataSet parameters) throws ReportDataFactoryException {
        int methodSeparatorIdx = query.indexOf(35);
        if (methodSeparatorIdx + 1 >= query.length()) {
            throw new ReportDataFactoryException("Malformed query: " + query);
        }
        if (methodSeparatorIdx == -1) {
            String constructorName;
            String[] parameterNames;
            int parameterStartIdx = query.indexOf(40);
            if (parameterStartIdx == -1) {
                parameterNames = new String[]{};
                constructorName = query;
            } else {
                parameterNames = this.createParameterList(query, parameterStartIdx);
                constructorName = query.substring(0, parameterStartIdx);
            }
            try {
                Constructor c = this.findDirectConstructor(constructorName, parameterNames.length);
                Object[] params = new Object[parameterNames.length];
                for (int i = 0; i < parameterNames.length; ++i) {
                    String name = parameterNames[i];
                    params[i] = DataSetUtility.getByName(parameters, name);
                }
                Object o = c.newInstance(params);
                if (o instanceof TableModel) {
                    return new TableReportData((TableModel)o);
                }
                return (ReportData)o;
            }
            catch (Exception e) {
                throw new ReportDataFactoryException("Unable to instantiate class for non static call.", e);
            }
        }
        return this.createComplexTableModel(query, methodSeparatorIdx, parameters);
    }

    private ReportData createComplexTableModel(String query, int methodSeparatorIdx, DataSet parameters) throws ReportDataFactoryException {
        String methodName;
        String[] methodParameterNames;
        String constructorSpec = query.substring(0, methodSeparatorIdx);
        int constParamIdx = constructorSpec.indexOf(40);
        if (constParamIdx == -1) {
            return this.loadFromDefaultConstructor(query, methodSeparatorIdx, parameters);
        }
        String className = query.substring(0, constParamIdx);
        String[] parameterNames = this.createParameterList(constructorSpec, constParamIdx);
        Constructor c = this.findIndirectConstructor(className, parameterNames.length);
        String methodQuery = query.substring(methodSeparatorIdx + 1);
        int parameterStartIdx = methodQuery.indexOf(40);
        if (parameterStartIdx == -1) {
            methodParameterNames = new String[]{};
            methodName = methodQuery;
        } else {
            methodName = methodQuery.substring(0, parameterStartIdx);
            methodParameterNames = this.createParameterList(methodQuery, parameterStartIdx);
        }
        Method m = this.findCallableMethod(className, methodName, methodParameterNames.length);
        try {
            Object[] constrParams = new Object[parameterNames.length];
            for (int i = 0; i < parameterNames.length; ++i) {
                String name = parameterNames[i];
                constrParams[i] = DataSetUtility.getByName(parameters, name);
            }
            Object o = c.newInstance(constrParams);
            Object[] methodParams = new Object[methodParameterNames.length];
            for (int i = 0; i < methodParameterNames.length; ++i) {
                String name = methodParameterNames[i];
                methodParams[i] = DataSetUtility.getByName(parameters, name);
            }
            Object data = m.invoke(o, methodParams);
            if (data instanceof TableModel) {
                return new TableReportData((TableModel)data);
            }
            return (ReportData)data;
        }
        catch (Exception e) {
            throw new ReportDataFactoryException("Unable to instantiate class for non static call.");
        }
    }

    private ReportData loadFromDefaultConstructor(String query, int methodSeparatorIdx, DataSet parameters) throws ReportDataFactoryException {
        String methodName;
        String[] parameterNames;
        String className = query.substring(0, methodSeparatorIdx);
        String methodSpec = query.substring(methodSeparatorIdx + 1);
        int parameterStartIdx = methodSpec.indexOf(40);
        if (parameterStartIdx == -1) {
            parameterNames = new String[]{};
            methodName = methodSpec;
        } else {
            parameterNames = this.createParameterList(methodSpec, parameterStartIdx);
            methodName = methodSpec.substring(0, parameterStartIdx);
        }
        try {
            Method m = this.findCallableMethod(className, methodName, parameterNames.length);
            Object[] params = new Object[parameterNames.length];
            for (int i = 0; i < parameterNames.length; ++i) {
                String name = parameterNames[i];
                params[i] = DataSetUtility.getByName(parameters, name);
            }
            if (Modifier.isStatic(m.getModifiers())) {
                Object o = m.invoke(null, params);
                if (o instanceof TableModel) {
                    return new TableReportData((TableModel)o);
                }
                return (ReportData)o;
            }
            ClassLoader classLoader = this.getClassLoader();
            Class<?> c = classLoader.loadClass(className);
            Object o = c.newInstance();
            if (o == null) {
                throw new ReportDataFactoryException("Unable to instantiate class for non static call.");
            }
            Object data = m.invoke(o, params);
            if (data instanceof TableModel) {
                return new TableReportData((TableModel)data);
            }
            return (ReportData)data;
        }
        catch (ReportDataFactoryException rdfe) {
            throw rdfe;
        }
        catch (Exception e) {
            throw new ReportDataFactoryException("Something went terribly wrong: ", e);
        }
    }

    private String[] createParameterList(String query, int parameterStartIdx) throws ReportDataFactoryException {
        int parameterEndIdx = query.lastIndexOf(41);
        if (parameterEndIdx < parameterStartIdx) {
            throw new ReportDataFactoryException("Malformed query: " + query);
        }
        String parameterText = query.substring(parameterStartIdx + 1, parameterEndIdx);
        CSVTokenizer tokenizer = new CSVTokenizer(parameterText);
        int size = tokenizer.countTokens();
        String[] parameterNames = new String[size];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            parameterNames[i] = tokenizer.nextToken();
            ++i;
        }
        return parameterNames;
    }

    protected ClassLoader getClassLoader() {
        return ObjectUtilities.getClassLoader((Class)(class$org$jfree$report$modules$data$beans$StaticReportDataFactory == null ? (class$org$jfree$report$modules$data$beans$StaticReportDataFactory = StaticReportDataFactory.class$("org.jfree.report.modules.data.beans.StaticReportDataFactory")) : class$org$jfree$report$modules$data$beans$StaticReportDataFactory));
    }

    private Method findCallableMethod(String className, String methodName, int paramCount) throws ReportDataFactoryException {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null) {
            throw new ReportDataFactoryException("No classloader!");
        }
        try {
            Class<?> c = classLoader.loadClass(className);
            if (Modifier.isAbstract(c.getModifiers())) {
                throw new ReportDataFactoryException("Abstract class cannot be handled!");
            }
            Method[] methods = c.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (!Modifier.isPublic(method.getModifiers()) || !method.getName().equals(methodName)) continue;
                Class<?> returnType = method.getReturnType();
                if (method.getParameterTypes().length != paramCount || !(class$javax$swing$table$TableModel == null ? StaticReportDataFactory.class$("javax.swing.table.TableModel") : class$javax$swing$table$TableModel).isAssignableFrom(returnType) && !(class$org$jfree$report$ReportData == null ? StaticReportDataFactory.class$("org.jfree.report.ReportData") : class$org$jfree$report$ReportData).isAssignableFrom(returnType)) continue;
                return method;
            }
        }
        catch (ClassNotFoundException e) {
            throw new ReportDataFactoryException("No such Class", e);
        }
        throw new ReportDataFactoryException("No such Method: " + className + "#" + methodName);
    }

    private Constructor findDirectConstructor(String className, int paramCount) throws ReportDataFactoryException {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null) {
            throw new ReportDataFactoryException("No classloader!");
        }
        try {
            Class<?> c = classLoader.loadClass(className);
            if (!(class$javax$swing$table$TableModel == null ? (class$javax$swing$table$TableModel = StaticReportDataFactory.class$("javax.swing.table.TableModel")) : class$javax$swing$table$TableModel).isAssignableFrom(c) && !(class$org$jfree$report$ReportData == null ? (class$org$jfree$report$ReportData = StaticReportDataFactory.class$("org.jfree.report.ReportData")) : class$org$jfree$report$ReportData).isAssignableFrom(c)) {
                throw new ReportDataFactoryException("The specified class must be either a TableModel or a ReportData implementation.");
            }
            if (Modifier.isAbstract(c.getModifiers())) {
                throw new ReportDataFactoryException("The specified class cannot be instantiated: it is abstract.");
            }
            Constructor<?>[] methods = c.getConstructors();
            for (int i = 0; i < methods.length; ++i) {
                Constructor<?> method = methods[i];
                if (!Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length != paramCount) continue;
                return method;
            }
        }
        catch (ClassNotFoundException e) {
            throw new ReportDataFactoryException("No such Class", e);
        }
        throw new ReportDataFactoryException("There is no constructor in class " + className + " that accepts " + paramCount + " parameters.");
    }

    private Constructor findIndirectConstructor(String className, int paramCount) throws ReportDataFactoryException {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null) {
            throw new ReportDataFactoryException("No classloader!");
        }
        try {
            Class<?> c = classLoader.loadClass(className);
            if (Modifier.isAbstract(c.getModifiers())) {
                throw new ReportDataFactoryException("The specified class cannot be instantiated: it is abstract.");
            }
            Constructor<?>[] methods = c.getConstructors();
            for (int i = 0; i < methods.length; ++i) {
                Constructor<?> method = methods[i];
                if (!Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length != paramCount) continue;
                return method;
            }
        }
        catch (ClassNotFoundException e) {
            throw new ReportDataFactoryException("No such Class", e);
        }
        throw new ReportDataFactoryException("There is no constructor in class " + className + " that accepts " + paramCount + " parameters.");
    }

    public void open() {
    }

    public void close() {
    }

    public ReportDataFactory derive() {
        return this;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

