/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.flow.raw;

import java.awt.Image;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.jfree.layouting.LibLayoutBoot;
import org.jfree.layouting.namespace.DefaultNamespaceCollection;
import org.jfree.layouting.namespace.NamespaceCollection;
import org.jfree.layouting.namespace.NamespaceDefinition;
import org.jfree.layouting.namespace.Namespaces;
import org.jfree.layouting.util.AttributeMap;
import org.jfree.report.DataFlags;
import org.jfree.report.DataSourceException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.flow.ReportJob;
import org.jfree.report.flow.ReportStructureRoot;
import org.jfree.report.flow.ReportTarget;
import org.jfree.report.flow.ReportTargetUtil;
import org.jfree.report.util.AttributeNameGenerator;
import org.jfree.util.Configuration;
import org.jfree.xmlns.common.AttributeList;
import org.jfree.xmlns.writer.XmlWriter;
import org.jfree.xmlns.writer.XmlWriterSupport;

public class XmlPrintReportTarget
implements ReportTarget {
    private ReportJob reportJob;
    private XmlWriter writer;
    private NamespaceCollection namespaces;
    private AttributeNameGenerator namespacePrefixGenerator;

    public XmlPrintReportTarget(ReportJob job, XmlWriter writer) {
        this.reportJob = job;
        this.writer = writer;
        NamespaceDefinition[] reportNamespaces = Namespaces.createFromConfig((Configuration)this.reportJob.getConfiguration(), (String)"org.jfree.report.namespaces.", null);
        NamespaceDefinition[] layoutNamespaces = Namespaces.createFromConfig((Configuration)LibLayoutBoot.getInstance().getGlobalConfig(), (String)"org.jfree.layouting.namespaces.", null);
        DefaultNamespaceCollection namespaces = new DefaultNamespaceCollection();
        namespaces.addDefinitions(reportNamespaces);
        namespaces.addDefinitions(layoutNamespaces);
        this.namespaces = namespaces;
        this.namespacePrefixGenerator = new AttributeNameGenerator();
    }

    public ReportJob getReportJob() {
        return this.reportJob;
    }

    public void startReport(ReportStructureRoot report) throws DataSourceException, ReportProcessingException {
        try {
            this.writer.writeComment("starting report");
        }
        catch (IOException e) {
            throw new ReportProcessingException("IOError", e);
        }
    }

    public void startElement(AttributeMap attrs) throws DataSourceException, ReportProcessingException {
        String namespace = ReportTargetUtil.getNamespaceFromAttribute(attrs);
        String elementType = ReportTargetUtil.getElemenTypeFromAttribute(attrs);
        try {
            AttributeList attrList = this.buildAttributeList(attrs);
            this.validateNamespace(namespace, attrList);
            this.writer.writeTag(namespace, elementType, attrList, false);
        }
        catch (IOException e) {
            throw new ReportProcessingException("IOError", e);
        }
    }

    public void processContent(DataFlags value) throws DataSourceException, ReportProcessingException {
        Object rawvalue = value.getValue();
        if (rawvalue == null) {
            return;
        }
        if (rawvalue instanceof Image) {
            return;
        }
        try {
            String text = String.valueOf(rawvalue);
            this.writer.writeText(XmlWriterSupport.normalize((String)text, (boolean)false));
        }
        catch (IOException e) {
            throw new ReportProcessingException("Failed", e);
        }
    }

    public void endElement(AttributeMap attrs) throws DataSourceException, ReportProcessingException {
        try {
            this.writer.writeCloseTag();
        }
        catch (IOException e) {
            throw new ReportProcessingException("IOError", e);
        }
    }

    public void endReport(ReportStructureRoot report) throws DataSourceException, ReportProcessingException {
        try {
            this.writer.writeComment("starting report");
        }
        catch (IOException e) {
            throw new ReportProcessingException("IOError", e);
        }
    }

    public NamespaceDefinition getNamespaceByUri(String uri) {
        return this.namespaces.getDefinition(uri);
    }

    public void processText(String text) throws DataSourceException, ReportProcessingException {
        try {
            this.writer.writeText(XmlWriterSupport.normalize((String)text, (boolean)false));
        }
        catch (IOException e) {
            throw new ReportProcessingException("IOError", e);
        }
    }

    public void commit() throws ReportProcessingException {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new ReportProcessingException("Failed to flush", e);
        }
    }

    public String getExportDescriptor() {
        return "raw/text+xml";
    }

    protected AttributeList buildAttributeList(AttributeMap attrs) {
        AttributeList attrList = new AttributeList();
        String[] namespaces = attrs.getNameSpaces();
        for (int i = 0; i < namespaces.length; ++i) {
            String attrNamespace = namespaces[i];
            if (this.isInternalNamespace(attrNamespace)) continue;
            Map localAttributes = attrs.getAttributes(attrNamespace);
            Iterator entries = localAttributes.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                String key = String.valueOf(entry.getKey());
                this.validateNamespace(attrNamespace, attrList);
                attrList.setAttribute(attrNamespace, key, String.valueOf(entry.getValue()));
            }
        }
        return attrList;
    }

    private void validateNamespace(String uri, AttributeList list) {
        if (this.writer.isNamespaceDefined(uri)) {
            return;
        }
        if (list.isNamespaceUriDefined(uri)) {
            return;
        }
        NamespaceDefinition def = this.getNamespaceByUri(uri);
        if (def != null) {
            String prefix = def.getPreferredPrefix();
            if (!this.writer.isNamespacePrefixDefined(prefix) && !list.isNamespacePrefixDefined(prefix)) {
                list.addNamespaceDeclaration(prefix, uri);
            } else {
                list.addNamespaceDeclaration(this.namespacePrefixGenerator.generateName(prefix), uri);
            }
        } else {
            list.addNamespaceDeclaration(this.namespacePrefixGenerator.generateName("auto"), uri);
        }
    }

    private boolean isInternalNamespace(String namespace) {
        return "http://jfreereport.sourceforge.net/namespaces/engine".equals(namespace);
    }
}

