/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.flow.raw;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.flow.ReportJob;
import org.jfree.report.flow.ReportTarget;
import org.jfree.report.flow.SinglePassReportProcessor;
import org.jfree.report.flow.raw.XmlPrintReportTarget;
import org.jfree.xmlns.writer.XmlWriter;

public class XmlPrintReportProcessor
extends SinglePassReportProcessor {
    private OutputStream outputStream;
    private String encoding;

    public XmlPrintReportProcessor(OutputStream outputStream, String encoding) {
        this.outputStream = outputStream;
        this.encoding = encoding;
    }

    protected ReportTarget createReportTarget(ReportJob job) throws ReportProcessingException {
        try {
            OutputStreamWriter osw = new OutputStreamWriter(this.outputStream, this.encoding);
            XmlWriter writer = new XmlWriter((Writer)osw);
            writer.writeXmlDeclaration(this.encoding);
            return new XmlPrintReportTarget(job, writer);
        }
        catch (IOException e) {
            throw new ReportProcessingException("Failed to create writer", e);
        }
    }
}

