/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.flow.paginating;

import org.jfree.layouting.ChainingLayoutProcess;
import org.jfree.layouting.DefaultLayoutProcess;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.StateException;
import org.jfree.layouting.output.OutputProcessor;
import org.jfree.layouting.output.pageable.PageableOutputProcessor;
import org.jfree.layouting.util.IntList;
import org.jfree.report.DataSourceException;
import org.jfree.report.ReportDataFactoryException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.flow.AbstractReportProcessor;
import org.jfree.report.flow.FlowController;
import org.jfree.report.flow.LibLayoutReportTarget;
import org.jfree.report.flow.ReportContext;
import org.jfree.report.flow.ReportJob;
import org.jfree.report.flow.ReportTarget;
import org.jfree.report.flow.ReportTargetState;
import org.jfree.report.flow.layoutprocessor.LayoutController;
import org.jfree.report.flow.layoutprocessor.LayoutControllerFactory;
import org.jfree.report.flow.paginating.PageState;
import org.jfree.report.flow.paginating.PageStateList;
import org.jfree.resourceloader.ResourceKey;
import org.jfree.resourceloader.ResourceManager;
import org.jfree.util.Log;

public abstract class PaginatingReportProcessor
extends AbstractReportProcessor {
    private PageableOutputProcessor outputProcessor;
    private PageStateList stateList;
    private IntList physicalMapping;
    private IntList logicalMapping;
    private static final boolean ASSERTATION = true;

    protected PaginatingReportProcessor(PageableOutputProcessor outputProcessor) {
        this.outputProcessor = outputProcessor;
    }

    public PageableOutputProcessor getOutputProcessor() {
        return this.outputProcessor;
    }

    protected LibLayoutReportTarget createTarget(ReportJob job) {
        if (this.outputProcessor == null) {
            throw new IllegalStateException("OutputProcessor is invalid.");
        }
        ChainingLayoutProcess layoutProcess = new ChainingLayoutProcess((LayoutProcess)new DefaultLayoutProcess((OutputProcessor)this.outputProcessor));
        ResourceManager resourceManager = job.getReportStructureRoot().getResourceManager();
        ResourceKey resourceKey = job.getReportStructureRoot().getBaseResource();
        return new LibLayoutReportTarget(job, resourceKey, resourceManager, (LayoutProcess)layoutProcess);
    }

    protected void prepareReportProcessing(ReportJob job) throws ReportDataFactoryException, DataSourceException, ReportProcessingException {
        if (job == null) {
            throw new NullPointerException();
        }
        long start = System.currentTimeMillis();
        this.processReportRun(job, this.createTarget(job));
        if (!this.outputProcessor.isGlobalStateComputed()) {
            throw new ReportProcessingException("Pagination has not yet been finished.");
        }
        this.processPaginationRun(job, this.createTarget(job));
        if (!this.outputProcessor.isPaginationFinished()) {
            throw new ReportProcessingException("Pagination has not yet been finished.");
        }
        if (!this.outputProcessor.isContentGeneratable()) {
            throw new ReportProcessingException("Illegal State.");
        }
        long end = System.currentTimeMillis();
    }

    protected PageStateList processPaginationRun(ReportJob job, LibLayoutReportTarget target) throws ReportDataFactoryException, DataSourceException, ReportProcessingException {
        if (job == null) {
            throw new NullPointerException();
        }
        this.stateList = new PageStateList(this);
        this.physicalMapping = new IntList(40);
        this.logicalMapping = new IntList(20);
        ReportContext context = this.createReportContext(job, target);
        LayoutControllerFactory layoutFactory = context.getLayoutControllerFactory();
        FlowController flowController = this.createFlowControler(context, job);
        LayoutController layoutController = layoutFactory.create(flowController, job.getReportStructureRoot(), null);
        try {
            int result;
            int newPhysPageCount;
            this.stateList.add(new PageState(target.saveState(), layoutController, this.outputProcessor.getPageCursor()));
            int logPageCount = this.outputProcessor.getLogicalPageCount();
            int physPageCount = this.outputProcessor.getPhysicalPageCount();
            while (layoutController.isAdvanceable()) {
                layoutController = layoutController.advance(target);
                target.commit();
                while (!layoutController.isAdvanceable() && layoutController.getParent() != null) {
                    LayoutController parent = layoutController.getParent();
                    layoutController = parent.join(layoutController.getFlowController());
                }
                if (!target.isPagebreakEncountered()) continue;
                int newLogPageCount = this.outputProcessor.getLogicalPageCount();
                newPhysPageCount = this.outputProcessor.getPhysicalPageCount();
                result = this.stateList.size() - 1;
                while (physPageCount < newPhysPageCount) {
                    this.physicalMapping.add(result);
                    ++physPageCount;
                }
                while (logPageCount < newLogPageCount) {
                    this.logicalMapping.add(result);
                    ++logPageCount;
                }
                logPageCount = newLogPageCount;
                physPageCount = newPhysPageCount;
                ReportTargetState targetState = target.saveState();
                PageState state = new PageState(targetState, layoutController, this.outputProcessor.getPageCursor());
                this.stateList.add(state);
                ReportTarget reportTarget = targetState.restore((OutputProcessor)this.outputProcessor);
                target.resetPagebreakFlag();
            }
            int newLogPageCount = this.outputProcessor.getLogicalPageCount();
            newPhysPageCount = this.outputProcessor.getPhysicalPageCount();
            result = this.stateList.size() - 1;
            while (physPageCount < newPhysPageCount) {
                this.physicalMapping.add(result);
                ++physPageCount;
            }
            while (logPageCount < newLogPageCount) {
                this.logicalMapping.add(result);
                ++logPageCount;
            }
        }
        catch (StateException e) {
            throw new ReportProcessingException("Argh, Unable to save the state!");
        }
        Log.debug((Object)("After pagination we have " + this.stateList.size() + " states"));
        return this.stateList;
    }

    public boolean isPaginated() {
        return this.outputProcessor.isPaginationFinished();
    }

    protected PageState getLogicalPageState(int page) {
        return this.stateList.get(this.logicalMapping.get(page));
    }

    protected PageState getPhysicalPageState(int page) {
        return this.stateList.get(this.physicalMapping.get(page));
    }

    public PageState processPage(PageState previousState) throws StateException, ReportProcessingException, ReportDataFactoryException, DataSourceException {
        ReportTargetState targetState = previousState.getTargetState();
        LibLayoutReportTarget target = (LibLayoutReportTarget)targetState.restore((OutputProcessor)this.outputProcessor);
        this.outputProcessor.setPageCursor(previousState.getPageCursor());
        LayoutController position = previousState.getLayoutController();
        while (position.isAdvanceable()) {
            position = position.advance(target);
            target.commit();
            while (!position.isAdvanceable() && position.getParent() != null) {
                LayoutController parent = position.getParent();
                position = parent.join(position.getFlowController());
            }
            if (!target.isPagebreakEncountered()) continue;
            PageState state = new PageState(target.saveState(), position, this.outputProcessor.getPageCursor());
            target.resetPagebreakFlag();
            return state;
        }
        return null;
    }
}

