/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.flow.paginating;

import java.util.ArrayList;
import org.jfree.layouting.StateException;
import org.jfree.report.DataSourceException;
import org.jfree.report.ReportDataFactoryException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.flow.paginating.PageState;
import org.jfree.report.flow.paginating.PaginatingReportProcessor;
import org.jfree.report.util.WeakReferenceList;

public class PageStateList {
    private static final int MASTERPOSITIONS_MAX = 10;
    private static final int MASTERPOSITIONS_MED = 4;
    private static final int PRIMARY_MAX = 20;
    private static final int MASTER4_MAX = 120;
    private ArrayList masterStates10;
    private ArrayList masterStates4;
    private ArrayList primaryStates;
    private int size;
    private PaginatingReportProcessor pageProcess;

    public PageStateList(PaginatingReportProcessor proc) {
        if (proc == null) {
            throw new NullPointerException("ReportProcessor null");
        }
        this.pageProcess = proc;
        this.primaryStates = new ArrayList();
        this.masterStates4 = new ArrayList();
        this.masterStates10 = new ArrayList();
    }

    private int getMasterPos(int pos, int maxListSize) {
        return pos / maxListSize;
    }

    protected PaginatingReportProcessor getPageProcess() {
        return this.pageProcess;
    }

    public int size() {
        return this.size;
    }

    public void add(PageState state) {
        if (state == null) {
            throw new NullPointerException();
        }
        if (this.size() < 20) {
            this.primaryStates.add(state);
            ++this.size;
        } else if (this.size() < 120) {
            int secPos = this.size() - 20;
            int masterPos = this.getMasterPos(secPos, 4);
            if (masterPos >= this.masterStates4.size()) {
                MasterList master = new MasterList(this, 4);
                this.masterStates4.add(master);
                master.add(state);
            } else {
                MasterList master = (MasterList)this.masterStates4.get(masterPos);
                master.add(state);
            }
            ++this.size;
        } else {
            int thirdPos = this.size() - 120;
            int masterPos = this.getMasterPos(thirdPos, 10);
            if (masterPos >= this.masterStates10.size()) {
                MasterList master = new MasterList(this, 10);
                this.masterStates10.add(master);
                master.add(state);
            } else {
                MasterList master = (MasterList)this.masterStates10.get(masterPos);
                master.add(state);
            }
            ++this.size;
        }
    }

    public void clear() {
        this.masterStates10.clear();
        this.masterStates4.clear();
        this.primaryStates.clear();
        this.size = 0;
    }

    public PageState get(int index) {
        if (index >= this.size() || index < 0) {
            throw new IndexOutOfBoundsException("Index is invalid. Index was " + index + "; size was " + this.size());
        }
        if (index < 20) {
            return (PageState)this.primaryStates.get(index);
        }
        if (index < 120) {
            MasterList master = (MasterList)this.masterStates4.get(this.getMasterPos(index -= 20, 4));
            return (PageState)master.get(index);
        }
        MasterList master = (MasterList)this.masterStates10.get(this.getMasterPos(index -= 120, 10));
        return (PageState)master.get(index);
    }

    private static final class MasterList
    extends WeakReferenceList {
        private final PageStateList master;

        private MasterList(PageStateList list, int maxChildCount) {
            super(maxChildCount);
            this.master = list;
        }

        protected Object restoreChild(int index) {
            PageState master = (PageState)this.getMaster();
            if (master == null) {
                return null;
            }
            int max = this.getChildPos(index);
            try {
                return this.restoreState(max, master);
            }
            catch (Exception rpe) {
                return null;
            }
        }

        private PageState restoreState(int count, PageState rootstate) throws ReportProcessingException, StateException, ReportDataFactoryException, DataSourceException {
            if (rootstate == null) {
                throw new NullPointerException("Master is null");
            }
            PageState state = rootstate;
            for (int i = 0; i <= count; ++i) {
                PaginatingReportProcessor pageProcess = this.master.getPageProcess();
                state = pageProcess.processPage(state);
                this.set(state, i + 1);
            }
            return state;
        }
    }
}

