/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.flow.layoutprocessor;

import java.util.Iterator;
import java.util.Map;
import org.jfree.layouting.input.style.CSSDeclarationRule;
import org.jfree.layouting.input.style.CSSStyleRule;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.StyleKeyRegistry;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.namespace.NamespaceDefinition;
import org.jfree.layouting.util.AttributeMap;
import org.jfree.report.DataSourceException;
import org.jfree.report.EmptyReportData;
import org.jfree.report.ReportDataFactoryException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.data.GlobalMasterRow;
import org.jfree.report.data.PrecomputeNode;
import org.jfree.report.data.PrecomputeNodeKey;
import org.jfree.report.data.PrecomputedValueRegistry;
import org.jfree.report.data.ReportDataRow;
import org.jfree.report.data.StaticExpressionRuntimeData;
import org.jfree.report.expressions.Expression;
import org.jfree.report.expressions.ExpressionRuntime;
import org.jfree.report.flow.EmptyReportTarget;
import org.jfree.report.flow.FlowControlOperation;
import org.jfree.report.flow.FlowController;
import org.jfree.report.flow.LayoutExpressionRuntime;
import org.jfree.report.flow.ReportContext;
import org.jfree.report.flow.ReportJob;
import org.jfree.report.flow.ReportStructureRoot;
import org.jfree.report.flow.ReportTarget;
import org.jfree.report.flow.layoutprocessor.LayoutController;
import org.jfree.report.structure.Element;
import org.jfree.report.structure.Group;
import org.jfree.report.structure.Node;
import org.jfree.report.structure.Section;
import org.jfree.resourceloader.Resource;
import org.jfree.resourceloader.ResourceKey;
import org.jfree.resourceloader.ResourceManager;
import org.jfree.util.Configuration;

public class LayoutControllerUtil {
    public static final EmptyReportData EMPTY_REPORT_DATA = new EmptyReportData();
    static /* synthetic */ Class class$org$jfree$layouting$input$style$StyleRule;

    private LayoutControllerUtil() {
    }

    public static int findNodeInParent(Section parentSection, Node n) {
        Node[] nodes = parentSection.getNodeArray();
        for (int i = 0; i < nodes.length; ++i) {
            Node node = nodes[i];
            if (node != n) continue;
            return i;
        }
        return -1;
    }

    public static StaticExpressionRuntimeData getStaticExpressionRuntime(FlowController fc, Object declaringParent) {
        GlobalMasterRow dataRow = fc.getMasterRow();
        ReportJob reportJob = fc.getReportJob();
        StaticExpressionRuntimeData sdd = new StaticExpressionRuntimeData();
        sdd.setData(dataRow.getReportDataRow().getReportData());
        sdd.setDeclaringParent(declaringParent);
        sdd.setConfiguration((Configuration)reportJob.getConfiguration());
        sdd.setReportContext(fc.getReportContext());
        return sdd;
    }

    public static LayoutExpressionRuntime getExpressionRuntime(FlowController fc, Object node) {
        LayoutExpressionRuntime ler = new LayoutExpressionRuntime();
        ler.setConfiguration((Configuration)fc.getReportJob().getConfiguration());
        ler.setReportContext(fc.getReportContext());
        GlobalMasterRow masterRow = fc.getMasterRow();
        ler.setDataRow(masterRow.getGlobalView());
        ReportDataRow reportDataRow = masterRow.getReportDataRow();
        if (reportDataRow == null) {
            ler.setData(EMPTY_REPORT_DATA);
            ler.setCurrentRow(-1);
        } else {
            ler.setData(reportDataRow.getReportData());
            ler.setCurrentRow(reportDataRow.getCursor());
        }
        ler.setDeclaringParent(node);
        return ler;
    }

    public static FlowController processFlowOperations(FlowController fc, FlowControlOperation[] ops) throws DataSourceException {
        for (int i = 0; i < ops.length; ++i) {
            FlowControlOperation op = ops[i];
            fc = fc.performOperation(op);
        }
        return fc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isGroupFinished(FlowController fc, Node node) throws DataSourceException {
        Node nodeParent = node.getParent();
        if (nodeParent == null) {
            return false;
        }
        Group group = nodeParent.getGroup();
        if (group == null) {
            return false;
        }
        LayoutExpressionRuntime ler = null;
        while (group != null) {
            Node parent;
            if (ler == null) {
                ler = LayoutControllerUtil.getExpressionRuntime(fc, node);
            }
            ler.setDeclaringParent(group);
            Expression groupingExpression = group.getGroupingExpression();
            if (groupingExpression != null) {
                Object groupFinished;
                groupingExpression.setRuntime(ler);
                try {
                    groupFinished = groupingExpression.computeValue();
                }
                finally {
                    groupingExpression.setRuntime(null);
                }
                if (Boolean.TRUE.equals(groupFinished)) {
                    return true;
                }
            }
            if ((parent = group.getParent()) == null) {
                group = null;
                continue;
            }
            group = parent.getGroup();
        }
        return false;
    }

    private static void mergeDeclarationRule(CSSDeclarationRule target, CSSDeclarationRule source) {
        Iterator it = source.getPropertyKeys();
        while (it.hasNext()) {
            StyleKey key = (StyleKey)it.next();
            CSSValue value = source.getPropertyCSSValue(key);
            boolean sourceImportant = source.isImportant(key);
            boolean targetImportant = target.isImportant(key);
            if (targetImportant) continue;
            target.setPropertyValue(key, value);
            target.setImportant(key, sourceImportant);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CSSDeclarationRule processStyleAttribute(Object styleAttributeValue, Element node, ExpressionRuntime runtime, CSSDeclarationRule targetRule) throws DataSourceException {
        if (targetRule == null) {
            try {
                targetRule = (CSSDeclarationRule)node.getStyle().clone();
            }
            catch (CloneNotSupportedException e) {
                targetRule = new CSSStyleRule(null, null);
            }
        }
        if (styleAttributeValue instanceof String) {
            String styleText = (String)styleAttributeValue;
            try {
                ReportContext reportContext = runtime.getReportContext();
                ReportStructureRoot root = reportContext.getReportStructureRoot();
                ResourceKey baseResource = root.getBaseResource();
                ResourceManager resourceManager = root.getResourceManager();
                byte[] bytes = styleText.getBytes("UTF-8");
                ResourceKey key = resourceManager.createKey((Object)bytes);
                Resource resource = resourceManager.create(key, baseResource, class$org$jfree$layouting$input$style$StyleRule == null ? (class$org$jfree$layouting$input$style$StyleRule = LayoutControllerUtil.class$("org.jfree.layouting.input.style.StyleRule")) : class$org$jfree$layouting$input$style$StyleRule);
                CSSDeclarationRule parsedRule = (CSSDeclarationRule)resource.getResource();
                LayoutControllerUtil.mergeDeclarationRule(targetRule, parsedRule);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (styleAttributeValue instanceof CSSStyleRule) {
            CSSStyleRule styleRule = (CSSStyleRule)styleAttributeValue;
            LayoutControllerUtil.mergeDeclarationRule(targetRule, (CSSDeclarationRule)styleRule);
        }
        Map styleExpressions = node.getStyleExpressions();
        Iterator styleExIt = styleExpressions.entrySet().iterator();
        while (styleExIt.hasNext()) {
            Map.Entry entry = styleExIt.next();
            String name = (String)entry.getKey();
            Expression expression = (Expression)entry.getValue();
            try {
                expression.setRuntime(runtime);
                Object value = expression.computeValue();
                if (value instanceof CSSValue) {
                    CSSValue cssvalue = (CSSValue)value;
                    StyleKey keyByName = StyleKeyRegistry.getRegistry().findKeyByName(name);
                    if (keyByName != null) {
                        targetRule.setPropertyValue(keyByName, cssvalue);
                        continue;
                    }
                    targetRule.setPropertyValueAsString(name, cssvalue.getCSSText());
                    continue;
                }
                if (value == null) continue;
                targetRule.setPropertyValueAsString(name, String.valueOf(value));
            }
            finally {
                expression.setRuntime(null);
            }
        }
        return targetRule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AttributeMap collectAttributes(Element node, ExpressionRuntime runtime) throws DataSourceException {
        AttributeMap attributes = node.getAttributeMap();
        AttributeMap attributeExpressions = node.getAttributeExpressionMap();
        String[] namespaces = attributeExpressions.getNameSpaces();
        for (int i = 0; i < namespaces.length; ++i) {
            String namespace = namespaces[i];
            Map attrEx = attributeExpressions.getAttributes(namespace);
            Iterator attributeExIt = attrEx.entrySet().iterator();
            while (attributeExIt.hasNext()) {
                Map.Entry entry = attributeExIt.next();
                String name = (String)entry.getKey();
                Expression expression = (Expression)entry.getValue();
                try {
                    expression.setRuntime(runtime);
                    Object value = expression.computeValue();
                    attributes.setAttribute(namespace, name, value);
                }
                finally {
                    expression.setRuntime(null);
                }
            }
        }
        return attributes;
    }

    public static AttributeMap processAttributes(Element node, ReportTarget target, ExpressionRuntime runtime) throws DataSourceException {
        AttributeMap attributes = LayoutControllerUtil.collectAttributes(node, runtime);
        CSSDeclarationRule rule = null;
        AttributeMap retval = new AttributeMap();
        String[] attrNamespaces = attributes.getNameSpaces();
        for (int i = 0; i < attrNamespaces.length; ++i) {
            String namespace = attrNamespaces[i];
            Map attributeMap = attributes.getAttributes(namespace);
            if (attributeMap == null) continue;
            NamespaceDefinition nsDef = target.getNamespaceByUri(namespace);
            Iterator attributeIt = attributeMap.entrySet().iterator();
            while (attributeIt.hasNext()) {
                Map.Entry entry = attributeIt.next();
                String key = (String)entry.getKey();
                if (LayoutControllerUtil.isStyleAttribute(nsDef, node.getType(), key)) {
                    Object styleAttributeValue = entry.getValue();
                    rule = LayoutControllerUtil.processStyleAttribute(styleAttributeValue, node, runtime, rule);
                    continue;
                }
                retval.setAttribute(namespace, key, entry.getValue());
            }
        }
        if (rule == null) {
            rule = LayoutControllerUtil.processStyleAttribute(null, node, runtime, rule);
        }
        if (rule != null && rule.getSize() > 0) {
            retval.setAttribute("http://jfreereport.sourceforge.net/namespaces/layout", "style", (Object)rule);
        }
        return retval;
    }

    private static boolean isStyleAttribute(NamespaceDefinition def, String elementName, String attrName) {
        if (def == null) {
            return false;
        }
        String[] styleAttr = def.getStyleAttribute(elementName);
        for (int i = 0; i < styleAttr.length; ++i) {
            String styleAttrib = styleAttr[i];
            if (!attrName.equals(styleAttrib)) continue;
            return true;
        }
        return false;
    }

    public static AttributeMap createEmptyMap(String namespace, String tagName) {
        AttributeMap map = new AttributeMap();
        map.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "namespace", (Object)namespace);
        map.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "type", (Object)tagName);
        return map;
    }

    public static Object performPrecompute(int expressionPosition, PrecomputeNodeKey nodeKey, LayoutController layoutController, FlowController flowController) throws ReportProcessingException, ReportDataFactoryException, DataSourceException {
        FlowController fc = flowController.createPrecomputeInstance();
        PrecomputedValueRegistry pcvr = fc.getPrecomputedValueRegistry();
        pcvr.startElementPrecomputation(nodeKey);
        LayoutController rootLc = layoutController.createPrecomputeInstance(fc);
        LayoutController rootParent = rootLc.getParent();
        EmptyReportTarget target = new EmptyReportTarget(fc.getReportJob(), fc.getExportDescriptor());
        LayoutController lc = rootLc;
        while (lc.isAdvanceable()) {
            lc = lc.advance(target);
            while (!lc.isAdvanceable() && lc.getParent() != null) {
                LayoutController parent = lc.getParent();
                lc = parent.join(lc.getFlowController());
            }
        }
        target.commit();
        PrecomputeNode precomputeNode = pcvr.currentNode();
        Object functionResult = precomputeNode.getFunctionResult(expressionPosition);
        pcvr.finishElementPrecomputation(nodeKey);
        return functionResult;
    }

    public static LayoutController skipInvisibleElement(LayoutController layoutController) throws ReportProcessingException, ReportDataFactoryException, DataSourceException {
        FlowController fc = layoutController.getFlowController();
        EmptyReportTarget target = new EmptyReportTarget(fc.getReportJob(), fc.getExportDescriptor());
        LayoutController rootParent = layoutController.getParent();
        LayoutController lc = layoutController;
        while (lc.isAdvanceable()) {
            lc = lc.advance(target);
            while (!lc.isAdvanceable() && lc.getParent() != null) {
                LayoutController parent = lc.getParent();
                lc = parent.join(lc.getFlowController());
                if (parent != rootParent) continue;
                target.commit();
                return lc;
            }
        }
        target.commit();
        throw new IllegalStateException("Ups - we did not get to the root parent again. This is awful and we cannot continue.");
    }

    public static Object evaluateExpression(FlowController flowController, Object declaringParent, Expression expression) throws DataSourceException {
        LayoutExpressionRuntime runtime = LayoutControllerUtil.getExpressionRuntime(flowController, declaringParent);
        try {
            expression.setRuntime(runtime);
            Object object = expression.computeValue();
            return object;
        }
        catch (DataSourceException dse) {
            throw dse;
        }
        catch (Exception e) {
            throw new DataSourceException("Failed to evaluate expression", e);
        }
        finally {
            expression.setRuntime(null);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

