/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.flow.layoutprocessor;

import org.jfree.layouting.util.AttributeMap;
import org.jfree.report.DataSourceException;
import org.jfree.report.ReportDataFactoryException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.data.ExpressionSlot;
import org.jfree.report.data.PrecomputeNodeKey;
import org.jfree.report.data.PrecomputedExpressionSlot;
import org.jfree.report.data.PrecomputedValueRegistry;
import org.jfree.report.data.RunningExpressionSlot;
import org.jfree.report.data.StaticExpressionRuntimeData;
import org.jfree.report.expressions.Expression;
import org.jfree.report.flow.FlowControlOperation;
import org.jfree.report.flow.FlowController;
import org.jfree.report.flow.LayoutExpressionRuntime;
import org.jfree.report.flow.ReportTarget;
import org.jfree.report.flow.layoutprocessor.LayoutController;
import org.jfree.report.flow.layoutprocessor.LayoutControllerUtil;
import org.jfree.report.structure.Element;
import org.jfree.util.Log;

public abstract class ElementLayoutController
implements LayoutController {
    public static final int NOT_STARTED = 0;
    public static final int OPENED = 1;
    public static final int WAITING_FOR_JOIN = 2;
    public static final int FINISHING = 3;
    public static final int FINISHED = 4;
    private int processingState = 0;
    private FlowController flowController;
    private Element element;
    private LayoutController parent;
    private boolean precomputing;
    private AttributeMap attributeMap;
    private int expressionsCount;
    private int iterationCount;

    protected ElementLayoutController() {
    }

    public String toString() {
        return "ElementLayoutController{processingState=" + this.processingState + ", element=" + this.element + ", precomputing=" + this.precomputing + ", expressionsCount=" + this.expressionsCount + ", iterationCount=" + this.iterationCount + '}';
    }

    public LayoutController getParent() {
        return this.parent;
    }

    public void initialize(Object node, FlowController flowController, LayoutController parent) throws DataSourceException, ReportDataFactoryException, ReportProcessingException {
        if (this.processingState != 0) {
            throw new IllegalStateException();
        }
        this.element = (Element)node;
        this.flowController = flowController;
        this.parent = parent;
        this.iterationCount = -1;
    }

    public final LayoutController advance(ReportTarget target) throws DataSourceException, ReportProcessingException, ReportDataFactoryException {
        int processingState = this.getProcessingState();
        switch (processingState) {
            case 0: {
                return this.startElement(target);
            }
            case 1: {
                return this.processContent(target);
            }
            case 3: {
                return this.finishElement(target);
            }
        }
        throw new IllegalStateException();
    }

    protected LayoutController startElement(ReportTarget target) throws DataSourceException, ReportProcessingException, ReportDataFactoryException {
        Element s = this.getElement();
        FlowController fc = this.getFlowController();
        fc = this.startData(target, fc);
        Expression[] expressions = s.getExpressions();
        fc = this.performElementPrecomputation(expressions, fc);
        if (!s.isVirtual()) {
            this.attributeMap = this.computeAttributes(fc, s, target);
            target.startElement(this.attributeMap);
        }
        ElementLayoutController derived = (ElementLayoutController)this.clone();
        derived.setProcessingState(1);
        derived.setFlowController(fc);
        derived.expressionsCount = expressions.length;
        derived.attributeMap = this.attributeMap;
        ++derived.iterationCount;
        return derived;
    }

    public AttributeMap getAttributeMap() {
        return this.attributeMap;
    }

    public int getExpressionsCount() {
        return this.expressionsCount;
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    protected FlowController startData(ReportTarget target, FlowController fc) throws DataSourceException, ReportProcessingException, ReportDataFactoryException {
        return fc;
    }

    protected AttributeMap computeAttributes(FlowController fc, Element element, ReportTarget target) throws DataSourceException {
        LayoutExpressionRuntime ler = LayoutControllerUtil.getExpressionRuntime(fc, element);
        return LayoutControllerUtil.processAttributes(element, target, ler);
    }

    protected abstract LayoutController processContent(ReportTarget var1) throws DataSourceException, ReportProcessingException, ReportDataFactoryException;

    protected LayoutController finishElement(ReportTarget target) throws ReportProcessingException, DataSourceException, ReportDataFactoryException {
        FlowController fc = this.handleDefaultEndElement(target);
        ElementLayoutController derived = (ElementLayoutController)this.clone();
        derived.setProcessingState(4);
        derived.setFlowController(fc);
        return derived;
    }

    protected FlowController handleDefaultEndElement(ReportTarget target) throws ReportProcessingException, DataSourceException, ReportDataFactoryException {
        Element e = this.getElement();
        if (!e.isVirtual()) {
            target.endElement(this.getAttributeMap());
        }
        FlowController fc = this.getFlowController();
        PrecomputedValueRegistry pcvr = fc.getPrecomputedValueRegistry();
        int expressionsCount = this.getExpressionsCount();
        if (expressionsCount != 0) {
            ExpressionSlot[] activeExpressions = fc.getActiveExpressions();
            for (int i = activeExpressions.length - expressionsCount; i < activeExpressions.length; ++i) {
                ExpressionSlot slot = activeExpressions[i];
                pcvr.addFunction(slot.getName(), slot.getValue());
            }
            fc = fc.deactivateExpressions();
        }
        if (!this.isPrecomputing()) {
            pcvr.finishElement(new ElementPrecomputeKey(e));
        }
        return fc;
    }

    public boolean isAdvanceable() {
        return this.processingState != 4;
    }

    public Element getElement() {
        return this.element;
    }

    public FlowController getFlowController() {
        return this.flowController;
    }

    public int getProcessingState() {
        return this.processingState;
    }

    public void setProcessingState(int processingState) {
        this.processingState = processingState;
    }

    public void setFlowController(FlowController flowController) {
        this.flowController = flowController;
    }

    public void setParent(LayoutController parent) {
        this.parent = parent;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            Log.error((Object)"Clone not supported: ", (Exception)e);
            throw new IllegalStateException("Clone must be supported.");
        }
    }

    public boolean isPrecomputing() {
        return this.precomputing;
    }

    protected FlowController performElementPrecomputation(Expression[] expressions, FlowController fc) throws ReportProcessingException, ReportDataFactoryException, DataSourceException {
        Element element = this.getElement();
        PrecomputedValueRegistry pcvr = fc.getPrecomputedValueRegistry();
        if (!this.isPrecomputing()) {
            pcvr.startElement(new ElementPrecomputeKey(element));
        }
        if (expressions.length > 0) {
            ExpressionSlot[] slots = new ExpressionSlot[expressions.length];
            StaticExpressionRuntimeData runtimeData = LayoutControllerUtil.getStaticExpressionRuntime(fc, element);
            for (int i = 0; i < expressions.length; ++i) {
                Expression expression = expressions[i];
                if (!this.isPrecomputing() && expression.isPrecompute()) {
                    Object value = LayoutControllerUtil.performPrecompute(i, new ElementPrecomputeKey(element), this, this.getFlowController());
                    slots[i] = new PrecomputedExpressionSlot(expression.getName(), value, expression.isPreserve());
                    continue;
                }
                slots[i] = new RunningExpressionSlot(expression, runtimeData, pcvr.currentNode());
            }
            fc = fc.activateExpressions(slots);
        }
        return fc;
    }

    protected FlowController tryRepeatingCommit(FlowController fc) throws DataSourceException {
        if (!this.isPrecomputing()) {
            FlowController cfc;
            boolean groupFinished;
            boolean advanceRequested = fc.isAdvanceRequested();
            boolean advanceable = fc.getMasterRow().isAdvanceable();
            if (advanceable && advanceRequested && !(groupFinished = LayoutControllerUtil.isGroupFinished(cfc = fc.performOperation(FlowControlOperation.COMMIT), this.getElement()))) {
                return cfc;
            }
        }
        return null;
    }

    public LayoutController createPrecomputeInstance(FlowController fc) {
        ElementLayoutController lc = (ElementLayoutController)this.clone();
        lc.setFlowController(fc);
        lc.setParent(null);
        lc.precomputing = true;
        return lc;
    }

    public Object getNode() {
        return this.getElement();
    }

    protected static class ElementPrecomputeKey
    implements PrecomputeNodeKey {
        private String name;
        private String id;
        private String namespace;
        private String tagName;

        protected ElementPrecomputeKey(Element element) {
            this.name = element.getName();
            this.tagName = element.getType();
            this.namespace = element.getNamespace();
            this.id = element.getId();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ElementPrecomputeKey that = (ElementPrecomputeKey)obj;
            if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
                return false;
            }
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) {
                return false;
            }
            return !(this.tagName != null ? !this.tagName.equals(that.tagName) : that.tagName != null);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 29 * result + (this.id != null ? this.id.hashCode() : 0);
            result = 29 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
            result = 29 * result + (this.tagName != null ? this.tagName.hashCode() : 0);
            return result;
        }

        public boolean equals(PrecomputeNodeKey otherKey) {
            return false;
        }
    }
}

