/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.flow.layoutprocessor;

import org.jfree.report.DataFlags;
import org.jfree.report.DataSourceException;
import org.jfree.report.ReportDataFactoryException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.data.DefaultDataFlags;
import org.jfree.report.expressions.Expression;
import org.jfree.report.flow.FlowController;
import org.jfree.report.flow.LayoutExpressionRuntime;
import org.jfree.report.flow.ReportContext;
import org.jfree.report.flow.ReportTarget;
import org.jfree.report.flow.layoutprocessor.ElementLayoutController;
import org.jfree.report.flow.layoutprocessor.LayoutController;
import org.jfree.report.flow.layoutprocessor.LayoutControllerFactory;
import org.jfree.report.flow.layoutprocessor.LayoutControllerUtil;
import org.jfree.report.structure.ContentElement;
import org.jfree.report.structure.Element;
import org.jfree.report.structure.Node;

public class ContentElementLayoutController
extends ElementLayoutController {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LayoutController processContent(ReportTarget target) throws DataSourceException, ReportProcessingException, ReportDataFactoryException {
        Object value;
        Element node = this.getElement();
        FlowController flowController = this.getFlowController();
        LayoutExpressionRuntime er = LayoutControllerUtil.getExpressionRuntime(flowController, node);
        ContentElement element = (ContentElement)node;
        Expression ex = element.getValueExpression();
        if (ex != null) {
            try {
                ex.setRuntime(er);
                value = ex.computeValue();
            }
            finally {
                ex.setRuntime(null);
            }
        } else {
            value = null;
        }
        if (value instanceof DataFlags) {
            target.processContent((DataFlags)value);
            ContentElementLayoutController derived = (ContentElementLayoutController)this.clone();
            derived.setProcessingState(3);
            derived.setFlowController(flowController);
            return derived;
        }
        if (value instanceof Node) {
            Node valueNode = (Node)value;
            valueNode.updateParent(node.getParent());
            ReportContext reportContext = flowController.getReportContext();
            LayoutControllerFactory layoutControllerFactory = reportContext.getLayoutControllerFactory();
            ContentElementLayoutController derived = (ContentElementLayoutController)this.clone();
            derived.setProcessingState(2);
            derived.setFlowController(flowController);
            return layoutControllerFactory.create(flowController, valueNode, derived);
        }
        if (ex != null) {
            target.processContent(new DefaultDataFlags(ex.getName(), value, true));
        }
        ContentElementLayoutController derived = (ContentElementLayoutController)this.clone();
        derived.setProcessingState(3);
        derived.setFlowController(flowController);
        return derived;
    }

    public LayoutController join(FlowController flowController) {
        ContentElementLayoutController derived = (ContentElementLayoutController)this.clone();
        derived.setProcessingState(3);
        derived.setFlowController(flowController);
        return derived;
    }
}

