/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.flow.layoutprocessor;

import java.util.ArrayList;
import org.jfree.layouting.namespace.NamespaceDefinition;
import org.jfree.layouting.util.AttributeMap;
import org.jfree.report.DataFlags;
import org.jfree.report.DataSourceException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.flow.ReportStructureRoot;
import org.jfree.report.flow.ReportTarget;

public class BufferedReportTarget
implements ReportTarget,
Cloneable {
    private static final int MTH_START_REPORT = 1;
    private static final int MTH_START_ELEMENT = 2;
    private static final int MTH_PROCESS_TEXT = 3;
    private static final int MTH_PROCESS_CONTENT = 4;
    private static final int MTH_END_ELEMENT = 5;
    private static final int MTH_END_REPORT = 6;
    private ReportTarget target;
    private ArrayList calls = new ArrayList();

    public ReportTarget getTarget() {
        return this.target;
    }

    public void setTarget(ReportTarget target) {
        this.target = target;
    }

    public void startReport(ReportStructureRoot report) throws DataSourceException, ReportProcessingException {
        this.calls.add(new RecordedCall(1, report));
    }

    public void startElement(AttributeMap attrs) throws DataSourceException, ReportProcessingException {
        try {
            this.calls.add(new RecordedCall(2, attrs.clone()));
        }
        catch (CloneNotSupportedException e) {
            throw new ReportProcessingException("Failed to clone attributes", e);
        }
    }

    public void processText(String text) throws DataSourceException, ReportProcessingException {
        this.calls.add(new RecordedCall(3, text));
    }

    public void processContent(DataFlags value) throws DataSourceException, ReportProcessingException {
        this.calls.add(new RecordedCall(4, value));
    }

    public void endElement(AttributeMap attrs) throws DataSourceException, ReportProcessingException {
        try {
            this.calls.add(new RecordedCall(5, attrs.clone()));
        }
        catch (CloneNotSupportedException e) {
            throw new ReportProcessingException("Failed to clone attributes", e);
        }
    }

    public void endReport(ReportStructureRoot report) throws DataSourceException, ReportProcessingException {
        this.calls.add(new RecordedCall(6, report));
    }

    public String getExportDescriptor() {
        return this.target.getExportDescriptor();
    }

    public NamespaceDefinition getNamespaceByUri(String uri) {
        return this.target.getNamespaceByUri(uri);
    }

    public void commit() throws ReportProcessingException {
    }

    public void close(ReportTarget target) throws ReportProcessingException, DataSourceException {
        RecordedCall[] objects = this.calls.toArray(new RecordedCall[this.calls.size()]);
        block8: for (int i = 0; i < objects.length; ++i) {
            RecordedCall call = objects[i];
            switch (call.getMethod()) {
                case 1: {
                    target.startReport((ReportStructureRoot)call.getParameters());
                    continue block8;
                }
                case 2: {
                    target.startElement((AttributeMap)call.getParameters());
                    continue block8;
                }
                case 3: {
                    target.processText((String)call.getParameters());
                    continue block8;
                }
                case 4: {
                    target.processContent((DataFlags)call.getParameters());
                    continue block8;
                }
                case 5: {
                    target.endElement((AttributeMap)call.getParameters());
                    continue block8;
                }
                case 6: {
                    target.endReport((ReportStructureRoot)call.getParameters());
                    continue block8;
                }
                default: {
                    throw new IllegalStateException("Invalid call recorded.");
                }
            }
        }
    }

    public Object clone() {
        try {
            BufferedReportTarget o = (BufferedReportTarget)super.clone();
            o.calls = (ArrayList)this.calls.clone();
            return o;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Clone failed");
        }
    }

    public static class RecordedCall {
        private int methodId;
        private Object parameters;

        public RecordedCall(int method, Object parameters) {
            this.methodId = method;
            this.parameters = parameters;
        }

        public int getMethod() {
            return this.methodId;
        }

        public Object getParameters() {
            return this.parameters;
        }
    }
}

