/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.flow;

import java.util.Iterator;
import java.util.Map;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.LayoutProcessState;
import org.jfree.layouting.StateException;
import org.jfree.layouting.input.style.StyleSheet;
import org.jfree.layouting.layouter.feed.InputFeed;
import org.jfree.layouting.layouter.feed.InputFeedException;
import org.jfree.layouting.namespace.NamespaceCollection;
import org.jfree.layouting.namespace.NamespaceDefinition;
import org.jfree.layouting.output.OutputProcessor;
import org.jfree.layouting.util.AttributeMap;
import org.jfree.report.DataFlags;
import org.jfree.report.DataSourceException;
import org.jfree.report.JFreeReport;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.flow.AbstractReportTarget;
import org.jfree.report.flow.ReportJob;
import org.jfree.report.flow.ReportStructureRoot;
import org.jfree.report.flow.ReportTarget;
import org.jfree.report.flow.ReportTargetState;
import org.jfree.report.flow.ReportTargetUtil;
import org.jfree.report.flow.StatefullReportTarget;
import org.jfree.resourceloader.ResourceKey;
import org.jfree.resourceloader.ResourceManager;

public class LibLayoutReportTarget
extends AbstractReportTarget
implements StatefullReportTarget {
    private InputFeed feed;
    private NamespaceCollection namespaces;
    private LayoutProcess layoutProcess;

    public LibLayoutReportTarget(ReportJob reportJob, ResourceKey baseResourceKey, ResourceManager resourceManager, LayoutProcess layoutProcess) {
        super(reportJob, resourceManager, baseResourceKey);
        if (layoutProcess == null) {
            throw new NullPointerException();
        }
        this.layoutProcess = layoutProcess;
        this.feed = layoutProcess.getInputFeed();
    }

    protected LibLayoutReportTarget(ReportJob reportJob, ResourceKey baseResource, ResourceManager resourceManager, LayoutProcess layoutProcess, NamespaceCollection namespaces) {
        this(reportJob, baseResource, resourceManager, layoutProcess);
        this.namespaces = namespaces;
    }

    public ReportTargetState saveState() throws StateException {
        LibLayoutReportTargetState state = new LibLayoutReportTargetState();
        state.fill(this);
        return state;
    }

    public void commit() {
    }

    public NamespaceCollection getNamespaces() {
        return this.namespaces;
    }

    public boolean isPagebreakEncountered() {
        return this.layoutProcess.isPagebreakEncountered();
    }

    protected LayoutProcess getLayoutProcess() {
        return this.layoutProcess;
    }

    protected InputFeed getInputFeed() {
        return this.feed;
    }

    public void startReport(ReportStructureRoot report) throws DataSourceException, ReportProcessingException {
        try {
            InputFeed feed = this.getInputFeed();
            feed.startDocument();
            feed.startMetaInfo();
            feed.addDocumentAttribute("base-resource", (Object)report.getBaseResource());
            feed.addDocumentAttribute("resource-manager", (Object)report.getResourceManager());
            String strictStyleMode = "false";
            if ("true".equals("false")) {
                feed.addDocumentAttribute("strict-style-mode", (Object)Boolean.TRUE);
            }
            NamespaceDefinition[] namespaces = this.createDefaultNameSpaces();
            for (int i = 0; i < namespaces.length; ++i) {
                NamespaceDefinition definition = namespaces[i];
                feed.startMetaNode();
                feed.setMetaNodeAttribute("type", (Object)"namespace");
                feed.setMetaNodeAttribute("definition", (Object)definition);
                feed.endMetaNode();
            }
            if (report instanceof JFreeReport) {
                JFreeReport realReport = (JFreeReport)report;
                int size = realReport.getStyleSheetCount();
                for (int i = 0; i < size; ++i) {
                    StyleSheet styleSheet = realReport.getStyleSheet(i);
                    feed.startMetaNode();
                    feed.setMetaNodeAttribute("type", (Object)"style");
                    feed.setMetaNodeAttribute("#content", (Object)styleSheet);
                    feed.endMetaNode();
                }
            }
            feed.endMetaInfo();
            this.namespaces = feed.getNamespaceCollection();
        }
        catch (InputFeedException dse) {
            dse.printStackTrace();
            throw new ReportProcessingException("Failed to process inputfeed", (Exception)((Object)dse));
        }
    }

    public void startElement(AttributeMap attrs) throws DataSourceException, ReportProcessingException {
        try {
            String namespace = ReportTargetUtil.getNamespaceFromAttribute(attrs);
            String type = ReportTargetUtil.getElemenTypeFromAttribute(attrs);
            InputFeed feed = this.getInputFeed();
            feed.startElement(namespace, type);
            this.handleAttributes(attrs);
        }
        catch (InputFeedException e) {
            throw new ReportProcessingException("Failed to process inputfeed", (Exception)((Object)e));
        }
    }

    public void processText(String text) throws DataSourceException, ReportProcessingException {
        try {
            InputFeed feed = this.getInputFeed();
            feed.addContent(text);
        }
        catch (InputFeedException e) {
            throw new ReportProcessingException("Failed to process inputfeed", (Exception)((Object)e));
        }
    }

    public void processContent(DataFlags value) throws DataSourceException, ReportProcessingException {
        InputFeed feed = this.getInputFeed();
        try {
            feed.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "content", value.getValue());
            feed.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "isChanged", (Object)String.valueOf(value.isChanged()));
            feed.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "isDate", (Object)String.valueOf(value.isDate()));
            feed.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "isNegative", (Object)String.valueOf(value.isNegative()));
            feed.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "isNull", (Object)String.valueOf(value.isNull()));
            feed.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "isNumber", (Object)String.valueOf(value.isNumeric()));
            feed.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "isPositive", (Object)String.valueOf(value.isPositive()));
            feed.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "isZero", (Object)String.valueOf(value.isZero()));
        }
        catch (InputFeedException e) {
            throw new ReportProcessingException("Failed to process inputfeed", (Exception)((Object)e));
        }
    }

    public NamespaceDefinition getNamespaceByUri(String uri) {
        if (uri == null) {
            return null;
        }
        return this.namespaces.getDefinition(uri);
    }

    protected void handleAttributes(AttributeMap map) throws ReportProcessingException {
        try {
            InputFeed feed = this.getInputFeed();
            String[] namespaces = map.getNameSpaces();
            for (int i = 0; i < namespaces.length; ++i) {
                String namespace = namespaces[i];
                Map localAttrs = map.getAttributes(namespace);
                Iterator it = localAttrs.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    feed.setAttribute(namespace, (String)entry.getKey(), entry.getValue());
                }
            }
        }
        catch (InputFeedException e) {
            throw new ReportProcessingException("Failed to set attribute", (Exception)((Object)e));
        }
    }

    public void endElement(AttributeMap attrs) throws DataSourceException, ReportProcessingException {
        InputFeed feed = this.getInputFeed();
        try {
            feed.endElement();
        }
        catch (InputFeedException e) {
            throw new ReportProcessingException("Failed to process inputfeed", (Exception)((Object)e));
        }
    }

    public void endReport(ReportStructureRoot report) throws DataSourceException, ReportProcessingException {
        try {
            this.getInputFeed().endDocument();
        }
        catch (InputFeedException e) {
            throw new ReportProcessingException("Failed to process inputfeed", (Exception)((Object)e));
        }
    }

    public void resetPagebreakFlag() {
        this.getInputFeed().resetPageBreakFlag();
    }

    public String getExportDescriptor() {
        return this.getLayoutProcess().getOutputMetaData().getExportDescriptor();
    }

    protected static class LibLayoutReportTargetState
    implements ReportTargetState {
        private LayoutProcessState layoutProcess;
        private ReportJob reportJob;
        private ResourceKey baseResourceKey;
        private ResourceManager resourceManager;
        private NamespaceCollection namespaceCollection;

        protected LibLayoutReportTargetState() {
        }

        public void fill(LibLayoutReportTarget target) throws StateException {
            this.layoutProcess = target.getLayoutProcess().saveState();
            this.reportJob = target.getReportJob();
            this.baseResourceKey = target.getBaseResource();
            this.resourceManager = target.getResourceManager();
            this.namespaceCollection = target.getNamespaces();
        }

        public ReportTarget restore(OutputProcessor out) throws StateException {
            LayoutProcess layoutProcess = this.layoutProcess.restore(out);
            return new LibLayoutReportTarget(this.reportJob, this.baseResourceKey, this.resourceManager, layoutProcess, this.namespaceCollection);
        }
    }
}

