/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.expressions.sys;

import java.util.ArrayList;
import java.util.Arrays;
import org.jfree.report.DataFlags;
import org.jfree.report.DataRow;
import org.jfree.report.DataSourceException;
import org.jfree.report.expressions.AbstractExpression;

public class GroupByExpression
extends AbstractExpression {
    private ArrayList fields = new ArrayList();
    private transient String[] fieldsCached;

    public Object computeValue() throws DataSourceException {
        DataRow dr = this.getDataRow();
        String[] columns = this.getField();
        for (int i = 0; i < columns.length; ++i) {
            String column = columns[i];
            DataFlags df = dr.getFlags(column);
            if (df == null || !df.isChanged()) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void setField(int index, String field) {
        if (this.fields.size() == index) {
            this.fields.add(field);
        } else {
            this.fields.set(index, field);
        }
        this.fieldsCached = null;
    }

    public String getField(int index) {
        return (String)this.fields.get(index);
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    public String[] getField() {
        if (this.fieldsCached == null) {
            this.fieldsCached = this.fields.toArray(new String[this.fields.size()]);
        }
        return (String[])this.fieldsCached.clone();
    }

    public void setField(String[] fields) {
        this.fields.clear();
        this.fields.addAll(Arrays.asList(fields));
        this.fieldsCached = (String[])fields.clone();
    }

    public Object clone() throws CloneNotSupportedException {
        GroupByExpression co = (GroupByExpression)super.clone();
        co.fields = (ArrayList)this.fields.clone();
        co.fieldsCached = this.fieldsCached;
        return co;
    }
}

