/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.expressions;

import org.jfree.formula.ContextEvaluationException;
import org.jfree.formula.ErrorValue;
import org.jfree.formula.FormulaContext;
import org.jfree.formula.LibFormulaErrorValue;
import org.jfree.formula.LocalizationContext;
import org.jfree.formula.function.FunctionRegistry;
import org.jfree.formula.operators.OperatorFactory;
import org.jfree.formula.typing.Type;
import org.jfree.formula.typing.TypeRegistry;
import org.jfree.formula.typing.coretypes.AnyType;
import org.jfree.report.DataFlags;
import org.jfree.report.DataRow;
import org.jfree.report.DataSourceException;
import org.jfree.util.Configuration;
import org.jfree.util.Log;

public class ReportFormulaContext
implements FormulaContext {
    private FormulaContext backend;
    private DataRow dataRow;
    private Object declaringElement;

    public ReportFormulaContext(FormulaContext backend, DataRow dataRow) {
        this.backend = backend;
        this.dataRow = dataRow;
    }

    public LocalizationContext getLocalizationContext() {
        return this.backend.getLocalizationContext();
    }

    public Configuration getConfiguration() {
        return this.backend.getConfiguration();
    }

    public FunctionRegistry getFunctionRegistry() {
        return this.backend.getFunctionRegistry();
    }

    public TypeRegistry getTypeRegistry() {
        return this.backend.getTypeRegistry();
    }

    public OperatorFactory getOperatorFactory() {
        return this.backend.getOperatorFactory();
    }

    public boolean isReferenceDirty(Object name) throws ContextEvaluationException {
        try {
            DataFlags flags = this.dataRow.getFlags(String.valueOf(name));
            if (flags == null) {
                throw new ContextEvaluationException((ErrorValue)new LibFormulaErrorValue(499));
            }
            return flags.isChanged();
        }
        catch (Exception e) {
            throw new ContextEvaluationException((ErrorValue)new LibFormulaErrorValue(499));
        }
    }

    public Type resolveReferenceType(Object name) {
        return AnyType.TYPE;
    }

    public Object resolveReference(Object name) throws ContextEvaluationException {
        if (name == null) {
            throw new NullPointerException();
        }
        try {
            return this.dataRow.get(String.valueOf(name));
        }
        catch (DataSourceException e) {
            Log.debug((Object)"Error while resolving formula reference: ", (Exception)((Object)e));
            throw new ContextEvaluationException((ErrorValue)new LibFormulaErrorValue(499));
        }
    }

    public DataRow getDataRow() {
        return this.dataRow;
    }

    public void setDataRow(DataRow dataRow) {
        this.dataRow = dataRow;
    }

    public Object getDeclaringElement() {
        return this.declaringElement;
    }

    public void setDeclaringElement(Object declaringElement) {
        this.declaringElement = declaringElement;
    }
}

