/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.data;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jfree.report.DataFlags;
import org.jfree.report.DataRow;
import org.jfree.report.DataSet;
import org.jfree.report.DataSourceException;
import org.jfree.report.ReportData;
import org.jfree.report.ReportDataFactory;
import org.jfree.report.ReportDataFactoryException;
import org.jfree.report.data.DefaultDataFlags;
import org.jfree.report.util.IntegerCache;
import org.jfree.util.ObjectUtilities;

public final class ReportDataRow
implements DataRow {
    private Map nameCache;
    private DataFlags[] data;
    private ReportData reportData;
    private int cursor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReportDataRow(ReportData reportData) throws DataSourceException {
        if (reportData == null) {
            throw new NullPointerException();
        }
        ReportData reportData2 = reportData;
        synchronized (reportData2) {
            boolean readable;
            this.reportData = reportData;
            reportData.setCursorPosition(0);
            if (reportData.isAdvanceable()) {
                readable = reportData.next() && reportData.isReadable();
                this.cursor = reportData.getCursorPosition();
            } else {
                readable = false;
                this.cursor = 0;
            }
            HashMap<String, Integer> nameCache = new HashMap<String, Integer>();
            int columnCount = reportData.getColumnCount();
            this.data = new DataFlags[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                String columnName = reportData.getColumnName(i);
                if (columnName != null) {
                    nameCache.put(columnName, IntegerCache.getInteger(i));
                }
                if (readable) {
                    Object value = reportData.get(i);
                    this.data[i] = new DefaultDataFlags(columnName, value, true);
                    continue;
                }
                this.data[i] = new DefaultDataFlags(columnName, null, true);
            }
            this.nameCache = Collections.unmodifiableMap(nameCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReportDataRow(ReportData reportData, ReportDataRow reportDataRow) throws DataSourceException {
        if (reportData == null) {
            throw new NullPointerException();
        }
        if (reportDataRow == null) {
            throw new NullPointerException();
        }
        ReportData reportData2 = reportData;
        synchronized (reportData2) {
            this.reportData = reportData;
            this.cursor = reportData.getCursorPosition();
            int columnCount = reportData.getColumnCount();
            this.data = new DataFlags[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                String columnName = reportData.getColumnName(i);
                Object value = reportData.get(i);
                boolean changed = ObjectUtilities.equal((Object)value, (Object)reportDataRow.get(i));
                this.data[i] = new DefaultDataFlags(columnName, value, changed);
            }
            this.nameCache = reportDataRow.nameCache;
        }
    }

    public static ReportDataRow createDataRow(ReportDataFactory dataFactory, String query, DataSet parameters) throws DataSourceException, ReportDataFactoryException {
        ReportData reportData = dataFactory.queryData(query, parameters);
        return new ReportDataRow(reportData);
    }

    public Object get(int col) throws DataSourceException {
        return this.data[col].getValue();
    }

    public Object get(String col) throws DataSourceException {
        Integer colIdx = (Integer)this.nameCache.get(col);
        if (colIdx == null) {
            throw new DataSourceException("Invalid name specified. There is no such column.");
        }
        return this.data[colIdx].getValue();
    }

    public String getColumnName(int col) {
        return this.data[col].getName();
    }

    public int getColumnCount() {
        return this.data.length;
    }

    public DataFlags getFlags(String col) throws DataSourceException {
        Integer colIdx = (Integer)this.nameCache.get(col);
        if (colIdx == null) {
            throw new DataSourceException("Invalid name specified. There is no such column.");
        }
        return this.data[colIdx];
    }

    public DataFlags getFlags(int col) {
        return this.data[col];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReportDataRow advance() throws DataSourceException {
        ReportData reportData = this.reportData;
        synchronized (reportData) {
            if (this.reportData.getCursorPosition() != this.cursor ? !this.reportData.setCursorPosition(this.cursor + 1) : !this.reportData.next()) {
                throw new DataSourceException("Unable to advance cursor position");
            }
            return new ReportDataRow(this.reportData, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAdvanceable() throws DataSourceException {
        ReportData reportData = this.reportData;
        synchronized (reportData) {
            if (this.reportData.getCursorPosition() != this.cursor && !this.reportData.setCursorPosition(this.cursor)) {
                return false;
            }
            return this.reportData.isAdvanceable();
        }
    }

    public ReportData getReportData() {
        return this.reportData;
    }

    public int getCursor() {
        return this.cursor;
    }
}

