/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.data;

import java.util.HashMap;
import org.jfree.formula.FormulaContext;
import org.jfree.report.flow.ReportContext;
import org.jfree.report.flow.ReportStructureRoot;
import org.jfree.report.flow.layoutprocessor.LayoutControllerFactory;
import org.jfree.report.i18n.ResourceBundleFactory;

public class ReportContextImpl
implements ReportContext {
    private HashMap backend = new HashMap();
    private String exportDescriptor;
    private FormulaContext formulaContext;
    private LayoutControllerFactory layoutControllerFactory;
    private ResourceBundleFactory resourceBundleFactory;
    private ReportStructureRoot reportStructureRoot;

    public void setReportStructureRoot(ReportStructureRoot reportStructureRoot) {
        this.reportStructureRoot = reportStructureRoot;
    }

    public ReportStructureRoot getReportStructureRoot() {
        return this.reportStructureRoot;
    }

    public String getExportDescriptor() {
        return this.exportDescriptor;
    }

    public void setExportDescriptor(String exportDescriptor) {
        this.exportDescriptor = exportDescriptor;
    }

    public FormulaContext getFormulaContext() {
        return this.formulaContext;
    }

    public void setFormulaContext(FormulaContext formulaContext) {
        this.formulaContext = formulaContext;
    }

    public LayoutControllerFactory getLayoutControllerFactory() {
        return this.layoutControllerFactory;
    }

    public void setLayoutControllerFactory(LayoutControllerFactory layoutControllerFactory) {
        this.layoutControllerFactory = layoutControllerFactory;
    }

    public void setAttribute(Object key, Object value) {
        DataCarrier dc = (DataCarrier)this.backend.get(key);
        if (dc == null) {
            if (value == null) {
                return;
            }
            DataCarrier ndc = new DataCarrier(value);
            this.backend.put(key, ndc);
            return;
        }
        if (dc.isLocked()) {
            throw new IllegalStateException("Context-Entry is locked.");
        }
        dc.setValue(value);
    }

    public void setSystemAttribute(Object key, Object value) {
        DataCarrier dc = (DataCarrier)this.backend.get(key);
        if (dc == null) {
            if (value == null) {
                return;
            }
            DataCarrier ndc = new DataCarrier(value);
            ndc.lock();
            this.backend.put(key, ndc);
            return;
        }
        if (dc.isLocked()) {
            throw new IllegalStateException("Context-Entry is locked.");
        }
        dc.setValue(value);
    }

    public Object getAttribute(Object key) {
        DataCarrier dc = (DataCarrier)this.backend.get(key);
        if (dc == null) {
            return null;
        }
        return dc.getValue();
    }

    public boolean isSystemAttribute(Object key) {
        DataCarrier dc = (DataCarrier)this.backend.get(key);
        if (dc == null) {
            return false;
        }
        return dc.isLocked();
    }

    public ResourceBundleFactory getResourceBundleFactory() {
        return this.resourceBundleFactory;
    }

    public void setResourceBundleFactory(ResourceBundleFactory resourceBundleFactory) {
        this.resourceBundleFactory = resourceBundleFactory;
    }

    private static class DataCarrier {
        private boolean locked;
        private Object value;

        private DataCarrier(Object value) {
            this.value = value;
        }

        public void lock() {
            this.locked = true;
        }

        public boolean isLocked() {
            return this.locked;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }
}

