/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.data;

import java.util.ArrayList;
import org.jfree.report.data.PrecomputeNode;
import org.jfree.report.data.PrecomputeNodeKey;

public class PrecomputeNodeImpl
implements PrecomputeNode {
    private PrecomputeNodeImpl parent;
    private PrecomputeNodeImpl next;
    private PrecomputeNodeImpl firstChild;
    private PrecomputeNodeImpl lastChild;
    private PrecomputeNodeKey key;
    private ArrayList functionResults;
    private ArrayList functionNames;

    public PrecomputeNodeImpl(PrecomputeNodeKey key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.key = key;
    }

    public PrecomputeNodeKey getKey() {
        return this.key;
    }

    public PrecomputeNode getParent() {
        return this.parent;
    }

    protected void setParent(PrecomputeNodeImpl parent) {
        this.parent = parent;
    }

    public PrecomputeNode getNext() {
        return this.next;
    }

    protected void setNext(PrecomputeNodeImpl next) {
        this.next = next;
    }

    public PrecomputeNode getFirstChild() {
        return this.firstChild;
    }

    protected void setFirstChild(PrecomputeNodeImpl firstChild) {
        this.firstChild = firstChild;
    }

    public PrecomputeNode getLastChild() {
        return this.lastChild;
    }

    protected void setLastChild(PrecomputeNodeImpl lastChild) {
        this.lastChild = lastChild;
    }

    public void add(PrecomputeNodeImpl node) {
        if (this.firstChild == null) {
            this.firstChild = node;
            this.firstChild.setParent(this);
            this.lastChild = node;
            return;
        }
        this.lastChild.setNext(node);
        this.lastChild.setParent(this);
    }

    public void addFunction(String name, Object value) {
        if (this.functionNames == null) {
            this.functionNames = new ArrayList();
            this.functionResults = new ArrayList();
        }
        this.functionNames.add(name);
        this.functionResults.add(value);
    }

    public int getFunctionCount() {
        if (this.functionNames == null) {
            return 0;
        }
        return this.functionNames.size();
    }

    public String getFunctionName(int idx) {
        if (this.functionNames == null) {
            throw new IndexOutOfBoundsException();
        }
        return (String)this.functionNames.get(idx);
    }

    public Object getFunctionResult(int idx) {
        if (this.functionResults == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.functionResults.get(idx);
    }

    public void prune() {
        if (this.parent == null) {
            return;
        }
        if (this.parent.getLastChild() != this) {
            throw new IllegalStateException("Cannot prune. Not the last child.");
        }
        if (this.parent.getFirstChild() == this) {
            this.parent.setFirstChild(null);
        }
        this.parent.setLastChild(null);
    }
}

