/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.data;

import org.jfree.report.DataFlags;
import org.jfree.report.DataRow;
import org.jfree.report.DataSourceException;
import org.jfree.report.data.DefaultDataFlags;
import org.jfree.report.util.LazyNameMap;
import org.jfree.util.ObjectUtilities;

public final class GlobalView
implements DataRow {
    private static final DataFlags[] EMPTY_DATA_FLAGS = new DataFlags[0];
    private DataFlags[] oldData;
    private LazyNameMap oldCache;
    private DataFlags[] data;
    private LazyNameMap nameCache;
    private int length;

    private GlobalView() {
    }

    public static GlobalView createView() {
        GlobalView gv = new GlobalView();
        gv.nameCache = new LazyNameMap();
        gv.oldCache = new LazyNameMap();
        gv.data = new DataFlags[10];
        gv.oldData = EMPTY_DATA_FLAGS;
        return gv;
    }

    private void ensureCapacity(int requestedSize) {
        int capacity = this.data.length;
        if (capacity > requestedSize) {
            return;
        }
        int newSize = Math.max(capacity * 2, requestedSize + 10);
        DataFlags[] newData = new DataFlags[newSize];
        System.arraycopy(this.data, 0, newData, 0, this.length);
        this.data = newData;
    }

    public synchronized void putField(String name, Object value, boolean update) throws DataSourceException {
        if (name == null) {
            throw new NullPointerException("Name must not be null.");
        }
        LazyNameMap.NameCarrier nc = this.nameCache.get(name);
        DefaultDataFlags flagedValue = new DefaultDataFlags(name, value, this.computeChange(name, value));
        if (nc != null) {
            this.data[nc.getValue()] = flagedValue;
            if (!update) {
                nc.increase();
            }
            return;
        }
        for (int i = 0; i < this.length; ++i) {
            DataFlags dataFlags = this.data[i];
            if (dataFlags != null) continue;
            this.data[i] = flagedValue;
            this.nameCache.setValue(name, i);
            return;
        }
        this.ensureCapacity(this.length + 1);
        this.data[this.length] = flagedValue;
        this.nameCache.setValue(name, this.length);
        ++this.length;
    }

    private boolean computeChange(String name, Object newValue) throws DataSourceException {
        LazyNameMap.NameCarrier onc = this.oldCache.get(name);
        if (onc == null) {
            return true;
        }
        DataFlags dataFlags = this.oldData[onc.getValue()];
        if (dataFlags == null) {
            return true;
        }
        return !ObjectUtilities.equal((Object)dataFlags.getValue(), (Object)newValue);
    }

    public Object get(int col) throws DataSourceException {
        DataFlags flag = this.getFlags(col);
        if (flag == null) {
            return null;
        }
        return flag.getValue();
    }

    public Object get(String col) throws DataSourceException {
        DataFlags flag = this.getFlags(col);
        if (flag == null) {
            return null;
        }
        return flag.getValue();
    }

    public String getColumnName(int col) {
        DataFlags flag = this.getFlags(col);
        if (flag == null) {
            return null;
        }
        return flag.getName();
    }

    public int getColumnCount() {
        return this.length;
    }

    public DataFlags getFlags(String col) {
        int idxVal;
        DataFlags df;
        LazyNameMap.NameCarrier idx = this.nameCache.get(col);
        if (idx != null && (df = this.data[idxVal = idx.getValue()]) != null) {
            return df;
        }
        LazyNameMap.NameCarrier oidx = this.oldCache.get(col);
        if (oidx == null) {
            return null;
        }
        int oidxVal = oidx.getValue();
        if (oidxVal < this.oldData.length) {
            return this.oldData[oidxVal];
        }
        return null;
    }

    public DataFlags getFlags(int col) {
        DataFlags df = this.data[col];
        if (df != null) {
            return df;
        }
        return this.oldData[col];
    }

    public GlobalView derive() {
        GlobalView gv = new GlobalView();
        gv.oldCache = (LazyNameMap)this.oldCache.clone();
        gv.data = (DataFlags[])this.data.clone();
        gv.oldData = (DataFlags[])this.oldData.clone();
        gv.length = this.length;
        gv.nameCache = (LazyNameMap)this.nameCache.clone();
        return gv;
    }

    public GlobalView advance() {
        GlobalView gv = new GlobalView();
        gv.oldCache = (LazyNameMap)this.nameCache.clone();
        gv.oldData = (DataFlags[])this.data.clone();
        gv.data = new DataFlags[gv.oldData.length];
        gv.length = this.length;
        gv.nameCache = new LazyNameMap();
        return gv;
    }

    public synchronized void removeColumn(String name) {
        LazyNameMap.NameCarrier idx = this.nameCache.get(name);
        if (idx == null) {
            return;
        }
        idx.decrease();
        if (idx.getInstanceCount() < 1) {
            this.nameCache.remove(name);
            this.data[idx.getValue()] = null;
        }
    }
}

