/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.data;

import org.jfree.report.DataRow;
import org.jfree.report.DataSourceException;
import org.jfree.report.data.ExpressionDataRow;
import org.jfree.report.data.GlobalView;
import org.jfree.report.data.ImportedVariablesDataRow;
import org.jfree.report.data.MasterDataRowChangeEvent;
import org.jfree.report.data.ParameterDataRow;
import org.jfree.report.data.ReportDataRow;
import org.jfree.report.flow.ReportContext;

public final class GlobalMasterRow {
    private ReportDataRow reportDataRow;
    private ParameterDataRow parameterDataRow;
    private ExpressionDataRow expressionDataRow;
    private GlobalMasterRow parentDataRow;
    private GlobalView globalView;
    private ImportedVariablesDataRow importedDataRow;

    private GlobalMasterRow() {
    }

    public static GlobalMasterRow createReportRow(ReportContext reportContext) {
        GlobalMasterRow gmr = new GlobalMasterRow();
        gmr.globalView = GlobalView.createView();
        gmr.expressionDataRow = new ExpressionDataRow(gmr, reportContext, 10);
        return gmr;
    }

    public static GlobalMasterRow createReportRow(GlobalMasterRow parentRow, ReportContext reportContext) {
        GlobalMasterRow gmr = GlobalMasterRow.createReportRow(reportContext);
        gmr.parentDataRow = parentRow;
        return gmr;
    }

    public ExpressionDataRow getExpressionDataRow() {
        return this.expressionDataRow;
    }

    public ReportDataRow getReportDataRow() {
        return this.reportDataRow;
    }

    public void setReportDataRow(ReportDataRow reportDataRow) throws DataSourceException {
        this.reportDataRow = reportDataRow;
        this.updateGlobalView();
    }

    public ParameterDataRow getParameterDataRow() {
        return this.parameterDataRow;
    }

    public void setParameterDataRow(ParameterDataRow parameterDataRow) throws DataSourceException {
        this.parameterDataRow = parameterDataRow;
        this.updateGlobalView();
    }

    public GlobalMasterRow getParentDataRow() {
        return this.parentDataRow;
    }

    public ImportedVariablesDataRow getImportedDataRow() {
        return this.importedDataRow;
    }

    public void setExportedDataRow(ImportedVariablesDataRow importedDataRow) throws DataSourceException {
        this.importedDataRow = importedDataRow;
        this.updateImportedParameterView();
    }

    public GlobalMasterRow derive() throws DataSourceException {
        return this.derive(null);
    }

    private GlobalMasterRow derive(GlobalMasterRow subReportRow) throws DataSourceException {
        GlobalMasterRow dataRow = new GlobalMasterRow();
        dataRow.parameterDataRow = this.parameterDataRow;
        dataRow.reportDataRow = this.reportDataRow;
        dataRow.expressionDataRow = this.expressionDataRow.derive(dataRow);
        dataRow.globalView = this.globalView.derive();
        if (this.parentDataRow != null) {
            dataRow.parentDataRow = this.parentDataRow.derive(subReportRow);
        }
        dataRow.importedDataRow = this.importedDataRow;
        return dataRow;
    }

    public GlobalMasterRow advance() throws DataSourceException {
        return this.advance(false, null);
    }

    private GlobalMasterRow advance(boolean deepTraversingOnly, GlobalMasterRow subReportRow) throws DataSourceException {
        GlobalMasterRow dataRow = new GlobalMasterRow();
        dataRow.globalView = this.globalView.advance();
        dataRow.parameterDataRow = this.parameterDataRow;
        dataRow.reportDataRow = !deepTraversingOnly && this.reportDataRow != null ? this.reportDataRow.advance() : this.reportDataRow;
        dataRow.updateGlobalView();
        if (this.expressionDataRow != null) {
            dataRow.expressionDataRow = this.expressionDataRow.advance(dataRow, deepTraversingOnly);
        }
        if (this.parentDataRow != null) {
            dataRow.parentDataRow = this.parentDataRow.advance(true, dataRow);
        }
        if (this.importedDataRow != null) {
            if (subReportRow == null) {
                throw new NullPointerException();
            }
            dataRow.importedDataRow = this.importedDataRow.advance(subReportRow);
            dataRow.updateImportedParameterView();
        }
        return dataRow;
    }

    private void updateImportedParameterView() throws DataSourceException {
        if (this.importedDataRow == null) {
            return;
        }
        int parameterCount = this.importedDataRow.getColumnCount();
        for (int i = 0; i < parameterCount; ++i) {
            String columnName = this.importedDataRow.getColumnName(i);
            if (columnName == null) continue;
            Object columnValue = this.importedDataRow.get(i);
            this.globalView.putField(columnName, columnValue, true);
        }
    }

    private void updateGlobalView() throws DataSourceException {
        Object columnValue;
        String columnName;
        int i;
        if (this.parameterDataRow != null) {
            int parameterCount = this.parameterDataRow.getColumnCount();
            for (i = 0; i < parameterCount; ++i) {
                columnName = this.parameterDataRow.getColumnName(i);
                if (columnName == null) continue;
                columnValue = this.parameterDataRow.get(i);
                this.globalView.putField(columnName, columnValue, true);
            }
        }
        if (this.reportDataRow != null) {
            int dataColCount = this.reportDataRow.getColumnCount();
            for (i = 0; i < dataColCount; ++i) {
                columnName = this.reportDataRow.getColumnName(i);
                if (columnName == null) continue;
                columnValue = this.reportDataRow.get(i);
                this.globalView.putField(columnName, columnValue, true);
            }
        }
    }

    public boolean isAdvanceable() throws DataSourceException {
        if (this.reportDataRow == null) {
            return false;
        }
        return this.reportDataRow.isAdvanceable();
    }

    public DataRow getGlobalView() {
        return this.globalView;
    }

    public void dataRowChanged(MasterDataRowChangeEvent chEvent) throws DataSourceException {
        int type = chEvent.getType();
        if (type == 1) {
            this.globalView.putField(chEvent.getColumnName(), chEvent.getColumnValue(), false);
        } else if (type == 3) {
            this.globalView.putField(chEvent.getColumnName(), chEvent.getColumnValue(), true);
        } else if (type == 2) {
            this.globalView.removeColumn(chEvent.getColumnName());
        }
    }
}

