/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.data;

import java.util.Date;
import org.jfree.report.DataFlags;

public class DefaultDataFlags
implements DataFlags {
    private Object value;
    private boolean changed;
    private String name;

    public DefaultDataFlags(String name, Object value, boolean changed) {
        this.value = value;
        this.changed = changed;
        this.name = name;
    }

    public boolean isNumeric() {
        return this.value instanceof Number;
    }

    public boolean isDate() {
        return this.value instanceof Date;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public boolean isZero() {
        if (!this.isNumeric()) {
            return false;
        }
        Number n = (Number)this.value;
        return n.floatValue() == 0.0f;
    }

    public boolean isNegative() {
        if (!this.isNumeric()) {
            return false;
        }
        Number n = (Number)this.value;
        return n.floatValue() < 0.0f;
    }

    public boolean isPositive() {
        if (!this.isNumeric()) {
            return false;
        }
        Number n = (Number)this.value;
        return n.floatValue() > 0.0f;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public Object getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("DefaultDataFlags={name=");
        b.append(this.name);
        b.append(", value=");
        b.append(this.value);
        b.append(", changed=");
        b.append(this.changed);
        b.append("}");
        return b.toString();
    }
}

