/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report;

import javax.swing.table.TableModel;
import org.jfree.report.DataSourceException;
import org.jfree.report.ReportData;

public class TableReportData
implements ReportData {
    private TableModel tableModel;
    private int cursor;
    private int rowMax;
    private int rowMin;
    private int cursorMaxPosition;

    public TableReportData(TableModel tableModel) {
        this(tableModel, 0, tableModel.getRowCount());
    }

    public TableReportData(TableModel tableModel, int start, int length) {
        this.tableModel = tableModel;
        this.rowMax = start + length;
        this.rowMin = start;
        this.cursorMaxPosition = length;
    }

    public int getColumnCount() throws DataSourceException {
        return this.tableModel.getColumnCount();
    }

    public boolean isReadable() throws DataSourceException {
        return this.cursor > 0 && this.cursor <= this.cursorMaxPosition;
    }

    public boolean setCursorPosition(int row) throws DataSourceException {
        if (row > this.cursorMaxPosition) {
            return false;
        }
        if (row < 0) {
            return false;
        }
        this.cursor = row;
        return true;
    }

    public boolean isAdvanceable() throws DataSourceException {
        return this.cursor < this.cursorMaxPosition;
    }

    public String getColumnName(int column) throws DataSourceException {
        return this.tableModel.getColumnName(column);
    }

    public Object get(int column) throws DataSourceException {
        if (!this.isReadable()) {
            throw new DataSourceException("Unable to read from datasource");
        }
        return this.tableModel.getValueAt(this.cursor - 1, column);
    }

    public boolean next() throws DataSourceException {
        if (this.cursor >= this.cursorMaxPosition) {
            return false;
        }
        ++this.cursor;
        return true;
    }

    public void close() throws DataSourceException {
    }

    public int getCursorPosition() throws DataSourceException {
        return this.cursor;
    }
}

