/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report;

import java.awt.print.PageFormat;
import java.util.ArrayList;
import java.util.Locale;
import org.jfree.base.config.HierarchicalConfiguration;
import org.jfree.base.config.ModifiableConfiguration;
import org.jfree.layouting.input.style.CSSPageRule;
import org.jfree.layouting.input.style.StyleRule;
import org.jfree.layouting.input.style.StyleSheet;
import org.jfree.layouting.input.style.StyleSheetUtility;
import org.jfree.report.EmptyReportDataFactory;
import org.jfree.report.JFreeReportBoot;
import org.jfree.report.ReportDataFactory;
import org.jfree.report.flow.ReportStructureRoot;
import org.jfree.report.structure.ReportDefinition;
import org.jfree.report.util.ReportParameters;
import org.jfree.resourceloader.ResourceKey;
import org.jfree.resourceloader.ResourceManager;
import org.jfree.util.Configuration;

public class JFreeReport
extends ReportDefinition
implements ReportStructureRoot {
    private ModifiableConfiguration reportConfiguration;
    private ArrayList styleSheets;
    private StyleSheet pageFormatStyleSheet;
    private CSSPageRule pageRule;
    private ReportParameters parameters;
    private ReportDataFactory dataFactory;
    private ResourceManager resourceManager;
    private ResourceKey baseResource;

    public JFreeReport() {
        this.setType("report");
        this.reportConfiguration = new HierarchicalConfiguration(JFreeReportBoot.getInstance().getGlobalConfig());
        this.styleSheets = new ArrayList();
        this.parameters = new ReportParameters();
        this.dataFactory = new EmptyReportDataFactory();
        this.pageFormatStyleSheet = new StyleSheet();
        this.pageRule = new CSSPageRule(this.pageFormatStyleSheet, null, null, null);
        this.pageFormatStyleSheet.addRule((StyleRule)this.pageRule);
        this.setQuery("default");
    }

    public Configuration getConfiguration() {
        return this.reportConfiguration;
    }

    public void addStyleSheet(StyleSheet s) {
        if (s == null) {
            throw new NullPointerException();
        }
        this.styleSheets.add(s);
    }

    public void removeStyleSheet(StyleSheet s) {
        this.styleSheets.remove(s);
    }

    public StyleSheet getStyleSheet(int i) {
        if (i == 0) {
            return this.pageFormatStyleSheet;
        }
        return (StyleSheet)this.styleSheets.get(i - 1);
    }

    public int getStyleSheetCount() {
        return this.styleSheets.size() + 1;
    }

    public JFreeReport getRootReport() {
        return this;
    }

    public ReportParameters getInputParameters() {
        return this.parameters;
    }

    public ReportDataFactory getDataFactory() {
        return this.dataFactory;
    }

    public void setDataFactory(ReportDataFactory dataFactory) {
        if (dataFactory == null) {
            throw new NullPointerException();
        }
        this.dataFactory = dataFactory;
    }

    public ResourceManager getResourceManager() {
        if (this.resourceManager == null) {
            this.resourceManager = new ResourceManager();
            this.resourceManager.registerDefaults();
        }
        return this.resourceManager;
    }

    public void setResourceManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public ResourceKey getBaseResource() {
        return this.baseResource;
    }

    public void setBaseResource(ResourceKey baseResource) {
        this.baseResource = baseResource;
    }

    public void setPageFormat(PageFormat format) {
        this.pageRule.clear();
        StyleSheetUtility.updateRuleForPage((CSSPageRule)this.pageRule, (PageFormat)format);
    }

    public PageFormat getPageFormat() {
        return StyleSheetUtility.getPageFormat((CSSPageRule)this.pageRule);
    }

    public ModifiableConfiguration getEditableConfiguration() {
        return this.reportConfiguration;
    }

    public Locale getLocale() {
        Locale locale = super.getLocale();
        if (locale == null) {
            return Locale.getDefault();
        }
        return locale;
    }

    public Object clone() throws CloneNotSupportedException {
        JFreeReport report = (JFreeReport)super.clone();
        report.dataFactory = this.dataFactory.derive();
        report.parameters = (ReportParameters)this.parameters.clone();
        report.pageRule = (CSSPageRule)this.pageRule.clone();
        report.styleSheets = (ArrayList)this.styleSheets.clone();
        report.pageFormatStyleSheet = this.pageFormatStyleSheet;
        return report;
    }
}

