/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.formula.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

public class ArrayConverter {
    private ArrayConverter() {
    }

    public static Object[] getAsList(Object maybeArray, Class arrayType) {
        if (maybeArray == null) {
            return null;
        }
        if (!maybeArray.getClass().isArray()) {
            return new Object[]{maybeArray};
        }
        ArrayList list = new ArrayList();
        ArrayConverter.addToList(list, maybeArray);
        Object o = Array.newInstance(arrayType, list.size());
        return list.toArray((Object[])o);
    }

    private static void addToList(List list, Object array) {
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Object value = Array.get(array, i);
            if (value == null) {
                list.add(null);
                continue;
            }
            if (!value.getClass().isArray()) {
                list.add(value);
                continue;
            }
            ArrayConverter.addToList(list, value);
        }
    }

    public static Object[] getArray(Object maybeArray, Class arrayType, int dims) {
        if (maybeArray == null) {
            return null;
        }
        if (dims <= 0) {
            return null;
        }
        if (!maybeArray.getClass().isArray()) {
            Object[] object = maybeArray;
            for (int i = 0; i < dims; ++i) {
                Object[] array = (Object[])Array.newInstance(arrayType, 1);
                array[0] = object;
                object = array;
            }
            return object;
        }
        if (ArrayConverter.getDimensionCount(maybeArray.getClass()) < dims) {
            return null;
        }
        return maybeArray;
    }

    public static int getDimensionCount(Class arrayClass) {
        int count = 0;
        while (arrayClass != null && arrayClass.isArray()) {
            ++count;
            arrayClass = arrayClass.getComponentType();
        }
        return count;
    }
}

