/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.formula.typing.sequence;

import org.jfree.formula.EvaluationException;
import org.jfree.formula.FormulaContext;
import org.jfree.formula.typing.ArrayCallback;
import org.jfree.formula.typing.Type;

public class NumberSequence {
    private int rowCursor = 0;
    private int columnCursor = 0;
    private Number number;
    private ArrayCallback array;
    private FormulaContext context;

    public NumberSequence(FormulaContext context) {
        this.context = context;
    }

    public NumberSequence(Number n, FormulaContext context) {
        this.number = n;
        this.context = context;
    }

    public NumberSequence(ArrayCallback array, FormulaContext context) {
        this.array = array;
        this.context = context;
    }

    public boolean hasNext() throws EvaluationException {
        if (this.number == null && this.array == null) {
            return false;
        }
        if (this.number != null && this.rowCursor == 0) {
            return true;
        }
        if (this.array != null) {
            int rowCount = this.array.getRowCount();
            int columnCount = this.array.getColumnCount();
            if (this.array != null && this.rowCursor < rowCount && this.columnCursor < columnCount) {
                while (this.rowCursor < rowCount) {
                    while (this.columnCursor < columnCount) {
                        Type type = this.array.getType(this.rowCursor, this.columnCursor);
                        boolean b = type.isFlagSet("type.numeric");
                        if (b) {
                            return true;
                        }
                        ++this.columnCursor;
                    }
                    this.columnCursor = 0;
                    ++this.rowCursor;
                }
            }
        }
        return false;
    }

    public Number nextNumber() throws EvaluationException {
        if (this.number != null && this.rowCursor == 0) {
            ++this.rowCursor;
            return this.number;
        }
        if (this.array != null) {
            Type type = this.array.getType(this.rowCursor, this.columnCursor);
            Object value = this.array.getValue(this.rowCursor, this.columnCursor);
            Number number = this.context.getTypeRegistry().convertToNumber(type, value);
            if (this.columnCursor == this.array.getColumnCount() - 1) {
                ++this.rowCursor;
                this.columnCursor = 0;
            } else {
                ++this.columnCursor;
            }
            return number;
        }
        return null;
    }
}

