/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.formula.typing;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.jfree.formula.EvaluationException;
import org.jfree.formula.FormulaContext;
import org.jfree.formula.LocalizationContext;
import org.jfree.formula.lvalues.LValue;
import org.jfree.formula.lvalues.TypeValuePair;
import org.jfree.formula.typing.ArrayCallback;
import org.jfree.formula.typing.DefaultComparator;
import org.jfree.formula.typing.ExtendedComparator;
import org.jfree.formula.typing.Type;
import org.jfree.formula.typing.TypeConversionException;
import org.jfree.formula.typing.TypeRegistry;
import org.jfree.formula.typing.coretypes.AnyType;
import org.jfree.formula.typing.coretypes.DateTimeType;
import org.jfree.formula.typing.coretypes.LogicalType;
import org.jfree.formula.typing.coretypes.NumberType;
import org.jfree.formula.typing.coretypes.TextType;
import org.jfree.formula.typing.sequence.NumberSequence;
import org.jfree.formula.util.DateUtil;
import org.jfree.util.Configuration;
import org.jfree.util.ObjectUtilities;

public class DefaultTypeRegistry
implements TypeRegistry {
    private FormulaContext context;
    private static final BigDecimal ZERO = new BigDecimal(0);
    private NumberFormat[] numberFormats;

    public ExtendedComparator getComparator(Type type1, Type type2) {
        DefaultComparator comparator = new DefaultComparator();
        comparator.inititalize(this.context);
        return comparator;
    }

    public Number convertToNumber(Type type1, Object value) throws TypeConversionException {
        LocalizationContext localizationContext = this.context.getLocalizationContext();
        if (value == null) {
            throw new TypeConversionException();
        }
        if (type1.isFlagSet("type.numeric") || type1.isFlagSet("type.any")) {
            if ((type1.isFlagSet("type.datetime") || type1.isFlagSet("type.time") || type1.isFlagSet("type.date") || type1.isFlagSet("type.any")) && value instanceof java.util.Date) {
                Number serial = DateUtil.toSerialDate((java.util.Date)value, localizationContext);
                return DateUtil.normalizeDate(serial, type1);
            }
            if (value instanceof Number) {
                return (Number)value;
            }
        }
        if ((type1.isFlagSet("type.logical") || type1.isFlagSet("type.any")) && value instanceof Boolean) {
            if (Boolean.TRUE.equals(value)) {
                return new Integer(1);
            }
            return new Integer(0);
        }
        if (type1.isFlagSet("type.text") || type1.isFlagSet("type.any")) {
            String val = value.toString();
            try {
                return new BigDecimal(val);
            }
            catch (NumberFormatException e) {
                Iterator datetimeIterator = localizationContext.getDateFormats(DateTimeType.DATETIME_TYPE).iterator();
                while (datetimeIterator.hasNext()) {
                    DateFormat df = (DateFormat)datetimeIterator.next();
                    try {
                        java.util.Date date = df.parse(val);
                        return DateUtil.toSerialDate(date, localizationContext);
                    }
                    catch (ParseException e2) {
                    }
                }
                Iterator dateIterator = localizationContext.getDateFormats(DateTimeType.DATE_TYPE).iterator();
                while (dateIterator.hasNext()) {
                    DateFormat df = (DateFormat)dateIterator.next();
                    try {
                        java.util.Date date = df.parse(val);
                        return DateUtil.toSerialDate(date, localizationContext);
                    }
                    catch (ParseException e3) {
                    }
                }
                Iterator timeIterator = localizationContext.getDateFormats(DateTimeType.TIME_TYPE).iterator();
                while (timeIterator.hasNext()) {
                    DateFormat df = (DateFormat)timeIterator.next();
                    try {
                        java.util.Date date = df.parse(val);
                        return DateUtil.toSerialDate(date, localizationContext);
                    }
                    catch (ParseException e4) {
                    }
                }
                for (int i = 0; i < this.numberFormats.length; ++i) {
                    try {
                        NumberFormat format = this.numberFormats[i];
                        return format.parse(val);
                    }
                    catch (ParseException e5) {
                        continue;
                    }
                }
            }
        }
        throw new TypeConversionException();
    }

    public void initialize(Configuration configuration, FormulaContext formulaContext) {
        this.context = formulaContext;
        this.numberFormats = this.loadNumberFormats();
    }

    protected NumberFormat[] loadNumberFormats() {
        ArrayList<DecimalFormat> formats = new ArrayList<DecimalFormat>();
        DecimalFormat defaultFormat = new DecimalFormat("#0.###", new DecimalFormatSymbols(Locale.US));
        this.activateBigDecimalMode(defaultFormat);
        formats.add(defaultFormat);
        return formats.toArray(new NumberFormat[formats.size()]);
    }

    private void activateBigDecimalMode(DecimalFormat format) {
        if (ObjectUtilities.isJDK14()) {
            try {
                Method method = DecimalFormat.class.getMethod("setParseBigDecimal", Boolean.TYPE);
                method.invoke((Object)format, Boolean.TRUE);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String convertToText(Type type1, Object value) throws TypeConversionException {
        if (value == null) {
            return "";
        }
        if (type1.isFlagSet("type.text")) {
            return value.toString();
        }
        if (type1.isFlagSet("type.logical")) {
            if (value instanceof Boolean) {
                Boolean b = (Boolean)value;
                if (Boolean.TRUE.equals(b)) {
                    return "TRUE";
                }
                return "FALSE";
            }
            throw new TypeConversionException();
        }
        if (type1.isFlagSet("type.numeric")) {
            if (type1.isFlagSet("type.datetime") || type1.isFlagSet("type.date") || type1.isFlagSet("type.time")) {
                java.util.Date d = this.convertToDate(type1, value);
                List dateFormats = this.context.getLocalizationContext().getDateFormats(type1);
                if (dateFormats != null && dateFormats.size() >= 1) {
                    DateFormat format = (DateFormat)dateFormats.get(0);
                    return format.format(d);
                }
                return SimpleDateFormat.getDateTimeInstance(0, 0).format(d);
            }
            try {
                Number n = this.convertToNumber(type1, value);
                NumberFormat format = this.getDefaultNumberFormat();
                return format.format(n);
            }
            catch (TypeConversionException typeConversionException) {
                // empty catch block
            }
        }
        return value.toString();
    }

    public Boolean convertToLogical(Type type1, Object value) throws TypeConversionException {
        if (value == null) {
            return Boolean.FALSE;
        }
        if (type1.isFlagSet("type.logical") || type1.isFlagSet("type.any")) {
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if ("true".equalsIgnoreCase(String.valueOf(value))) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (type1.isFlagSet("type.numeric")) {
            Number num;
            if (value instanceof Number && !ZERO.equals(num = (Number)value)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (type1.isFlagSet("type.text")) {
            String str = value.toString();
            if ("TRUE".equalsIgnoreCase(str)) {
                return Boolean.TRUE;
            }
            if ("FALSE".equalsIgnoreCase(str)) {
                return Boolean.FALSE;
            }
        }
        throw new TypeConversionException();
    }

    public java.util.Date convertToDate(Type type1, Object value) throws TypeConversionException {
        if ((type1.isFlagSet("type.numeric") || type1.isFlagSet("type.any")) && (type1.isFlagSet("type.date") || type1.isFlagSet("type.datetime") || type1.isFlagSet("type.time") || type1.isFlagSet("type.any")) && value instanceof java.util.Date) {
            return DateUtil.normalizeDate((java.util.Date)value, type1);
        }
        Number serial = this.convertToNumber(type1, value);
        return DateUtil.toJavaDate(serial, this.context.getLocalizationContext());
    }

    protected NumberFormat getDefaultNumberFormat() {
        Locale locale = this.context.getLocalizationContext().getLocale();
        return new DecimalFormat("#0.#########", new DecimalFormatSymbols(locale));
    }

    private TypeValuePair convertToSequence(Type targetType, TypeValuePair valuePair) throws TypeConversionException {
        if (targetType.isFlagSet("type.numeric")) {
            return new TypeValuePair(targetType, this.convertToNumberSequence(valuePair.getType(), valuePair.getValue()));
        }
        throw new TypeConversionException();
    }

    public NumberSequence convertToNumberSequence(Type type, Object value) throws TypeConversionException {
        if (type.isFlagSet("type.numeric.sequence")) {
            if (value instanceof NumberSequence) {
                return (NumberSequence)value;
            }
            throw new TypeConversionException();
        }
        if (type.isFlagSet("type.array")) {
            if (value instanceof ArrayCallback) {
                return new NumberSequence((ArrayCallback)value, this.context);
            }
            throw new TypeConversionException();
        }
        if (type.isFlagSet("type.scalar") && type.isFlagSet("type.numeric")) {
            return new NumberSequence(this.convertToNumber(type, value), this.context);
        }
        throw new TypeConversionException();
    }

    public TypeValuePair convertTo(Type targetType, TypeValuePair valuePair) throws TypeConversionException {
        Object o;
        if (targetType.isFlagSet("type.array")) {
            if (valuePair.getType().isFlagSet("type.array")) {
                if (valuePair.getType().isFlagSet("type.sequence")) {
                    return this.convertToSequence(targetType, valuePair);
                }
                if (targetType.isFlagSet("type.sequence")) {
                    return this.convertToSequence(targetType, valuePair);
                }
                return this.convertArrayToArray(targetType, valuePair);
            }
            if (targetType.isFlagSet("type.sequence")) {
                return this.convertToSequence(targetType, valuePair);
            }
            Object retval = this.convertPlainToPlain(targetType, valuePair.getType(), valuePair.getValue());
            return new TypeValuePair(targetType, new ArrayConverterCallback(retval, targetType));
        }
        Object value = valuePair.getValue();
        if (value == (o = this.convertPlainToPlain(targetType, valuePair.getType(), value))) {
            return valuePair;
        }
        return new TypeValuePair(targetType, o);
    }

    private Object convertPlainToPlain(Type targetType, Type type, Object value) throws TypeConversionException {
        if (targetType.isFlagSet("type.numeric")) {
            if (targetType.isFlagSet("type.logical")) {
                if (type.isFlagSet("type.logical")) {
                    return value;
                }
                return this.convertToLogical(type, value);
            }
            Number serial = this.convertToNumber(type, value);
            if (targetType.isFlagSet("type.date") || targetType.isFlagSet("type.datetime") || targetType.isFlagSet("type.time")) {
                Number normalizedSerial = DateUtil.normalizeDate(serial, targetType);
                java.util.Date toJavaDate = DateUtil.toJavaDate(normalizedSerial, this.context.getLocalizationContext());
                return DateUtil.normalizeDate(toJavaDate, targetType, false);
            }
            return serial;
        }
        if (targetType.isFlagSet("type.text")) {
            return this.convertToText(type, value);
        }
        return value;
    }

    private TypeValuePair convertArrayToArray(Type targetType, TypeValuePair pair) throws TypeConversionException {
        Object value = pair.getValue();
        if (value instanceof ArrayCallback) {
            ArrayCallback array = (ArrayCallback)value;
            for (int i = 0; i < array.getRowCount(); ++i) {
                int j = 0;
                if (j >= array.getColumnCount()) continue;
                throw new UnsupportedOperationException("Not implemented exception");
            }
        }
        throw new TypeConversionException();
    }

    public Type guessTypeOfObject(Object o) {
        if (o instanceof Number) {
            return NumberType.GENERIC_NUMBER;
        }
        if (o instanceof Time) {
            return DateTimeType.TIME_TYPE;
        }
        if (o instanceof Date) {
            return DateTimeType.DATE_TYPE;
        }
        if (o instanceof java.util.Date) {
            return DateTimeType.DATETIME_TYPE;
        }
        if (o instanceof Boolean) {
            return LogicalType.TYPE;
        }
        if (o instanceof String) {
            return TextType.TYPE;
        }
        return AnyType.TYPE;
    }

    private static class ArrayConverterCallback
    implements ArrayCallback {
        private Object retval;
        private Type targetType;

        private ArrayConverterCallback(Object retval, Type targetType) {
            this.retval = retval;
            this.targetType = targetType;
        }

        public LValue getRaw(int row, int column) {
            return null;
        }

        public Object getValue(int row, int column) throws EvaluationException {
            if (row == 0 && column == 0) {
                return this.retval;
            }
            return null;
        }

        public Type getType(int row, int column) throws EvaluationException {
            if (row == 0 && column == 0) {
                return this.targetType;
            }
            return null;
        }

        public int getColumnCount() {
            return 1;
        }

        public int getRowCount() {
            return 1;
        }
    }
}

