/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.formula.typing;

import java.math.BigDecimal;
import org.jfree.formula.FormulaContext;
import org.jfree.formula.typing.ExtendedComparator;
import org.jfree.formula.typing.Type;
import org.jfree.formula.typing.TypeConversionException;
import org.jfree.formula.typing.TypeRegistry;
import org.jfree.util.ObjectUtilities;

public class DefaultComparator
implements ExtendedComparator {
    private FormulaContext context;
    public static final Integer LESS = new Integer(-1);
    public static final Integer EQUAL = new Integer(0);
    private static final Integer MORE = new Integer(1);

    public void inititalize(FormulaContext context) {
        this.context = context;
    }

    public boolean isEqual(Type type1, Object value1, Type type2, Object value2) {
        TypeRegistry typeRegistry = this.context.getTypeRegistry();
        try {
            Number number1 = typeRegistry.convertToNumber(type1, value1);
            Number number2 = typeRegistry.convertToNumber(type2, value2);
            BigDecimal bd1 = new BigDecimal(number1.toString());
            BigDecimal bd2 = new BigDecimal(number2.toString());
            if (bd1.signum() != bd2.signum()) {
                return false;
            }
            BigDecimal result = bd1.subtract(bd2);
            return result.signum() == 0;
        }
        catch (TypeConversionException nfe) {
            if (type1.isFlagSet("type.text") || type2.isFlagSet("type.text")) {
                String text1 = null;
                String text2 = null;
                try {
                    text1 = typeRegistry.convertToText(type1, value1);
                    text2 = typeRegistry.convertToText(type2, value2);
                }
                catch (TypeConversionException nfe2) {
                    // empty catch block
                }
                if (text1 == null && text2 == null) {
                    return true;
                }
                if (text1 == null || text2 == null) {
                    return false;
                }
                return ObjectUtilities.equal((Object)text1, (Object)text2);
            }
            return ObjectUtilities.equal((Object)value1, (Object)value2);
        }
    }

    public Integer compare(Type type1, Object value1, Type type2, Object value2) {
        if (value1 == null && value2 == null) {
            return EQUAL;
        }
        if (value1 == null) {
            return LESS;
        }
        if (value2 == null) {
            return MORE;
        }
        if (type1.isFlagSet("type.scalar") && type2.isFlagSet("type.scalar") && value1 instanceof Comparable && value2 instanceof Comparable) {
            Comparable c1 = (Comparable)value1;
            try {
                int result = c1.compareTo(value2);
                if (result == 0) {
                    return EQUAL;
                }
                if (result > 0) {
                    return MORE;
                }
                return LESS;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        TypeRegistry typeRegistry = this.context.getTypeRegistry();
        try {
            BigDecimal result;
            Number number1 = typeRegistry.convertToNumber(type1, value1);
            Number number2 = typeRegistry.convertToNumber(type2, value2);
            BigDecimal bd1 = new BigDecimal(number1.toString());
            BigDecimal bd2 = new BigDecimal(number2.toString());
            if (bd1.signum() != bd2.signum()) {
                if (bd1.signum() < 0) {
                    return LESS;
                }
                if (bd1.signum() > 0) {
                    return MORE;
                }
            }
            if ((result = bd1.subtract(bd2)).signum() == 0) {
                return EQUAL;
            }
            if (result.signum() > 0) {
                return MORE;
            }
            return LESS;
        }
        catch (TypeConversionException nfe) {
            String text1 = null;
            String text2 = null;
            try {
                text1 = typeRegistry.convertToText(type1, value1);
                text2 = typeRegistry.convertToText(type2, value2);
            }
            catch (TypeConversionException e) {
                // empty catch block
            }
            if (text1 == null && text2 == null) {
                return EQUAL;
            }
            if (text1 == null) {
                return LESS;
            }
            if (text2 == null) {
                return MORE;
            }
            int result = text1.compareTo(text2);
            if (result == 0) {
                return EQUAL;
            }
            if (result > 0) {
                return MORE;
            }
            return LESS;
        }
    }
}

