/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.formula.operators;

import java.math.BigDecimal;
import org.jfree.formula.EvaluationException;
import org.jfree.formula.LibFormulaErrorValue;
import org.jfree.formula.operators.AbstractNumericOperator;
import org.jfree.formula.util.NumberUtil;
import org.jfree.util.Log;

public class DivideOperator
extends AbstractNumericOperator {
    public Number evaluate(Number number1, Number number2) throws EvaluationException {
        BigDecimal bd1 = new BigDecimal(number1.toString());
        BigDecimal bd2 = new BigDecimal(number2.toString());
        if (bd2.signum() == 0) {
            Log.debug((Object)("Preventing a Division by Zero: " + number2));
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARITHMETIC_VALUE);
        }
        BigDecimal divide = bd1.divide(bd2, 40, 4);
        return NumberUtil.removeTrailingZeros(divide);
    }

    public int getLevel() {
        return 100;
    }

    public String toString() {
        return "/";
    }

    public boolean isLeftOperation() {
        return true;
    }

    public boolean isAssociative() {
        return false;
    }
}

