/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.formula.operators;

import org.jfree.formula.EvaluationException;
import org.jfree.formula.FormulaContext;
import org.jfree.formula.LibFormulaErrorValue;
import org.jfree.formula.lvalues.TypeValuePair;
import org.jfree.formula.operators.InfixOperator;
import org.jfree.formula.typing.TypeRegistry;
import org.jfree.formula.typing.coretypes.TextType;

public class ConcatOperator
implements InfixOperator {
    public TypeValuePair evaluate(FormulaContext context, TypeValuePair value1, TypeValuePair value2) throws EvaluationException {
        TypeRegistry typeRegistry = context.getTypeRegistry();
        Object raw1 = value1.getValue();
        Object raw2 = value2.getValue();
        if (raw1 == null || raw2 == null) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_NA_VALUE);
        }
        String text1 = typeRegistry.convertToText(value1.getType(), raw1);
        String text2 = typeRegistry.convertToText(value2.getType(), raw2);
        if (text1 == null && text2 == null) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        if (text1 == null) {
            return new TypeValuePair(TextType.TYPE, text2);
        }
        if (text2 == null) {
            return new TypeValuePair(TextType.TYPE, text1);
        }
        return new TypeValuePair(TextType.TYPE, text1 + text2);
    }

    public int getLevel() {
        return 300;
    }

    public String toString() {
        return "&";
    }

    public boolean isLeftOperation() {
        return true;
    }

    public boolean isAssociative() {
        return false;
    }
}

