/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.formula.operators;

import org.jfree.formula.EvaluationException;
import org.jfree.formula.FormulaContext;
import org.jfree.formula.LibFormulaErrorValue;
import org.jfree.formula.lvalues.TypeValuePair;
import org.jfree.formula.operators.InfixOperator;
import org.jfree.formula.typing.ExtendedComparator;
import org.jfree.formula.typing.Type;
import org.jfree.formula.typing.TypeRegistry;
import org.jfree.formula.typing.coretypes.LogicalType;

public abstract class AbstractCompareOperator
implements InfixOperator {
    private static final TypeValuePair RETURN_TRUE = new TypeValuePair(LogicalType.TYPE, Boolean.TRUE);
    private static final TypeValuePair RETURN_FALSE = new TypeValuePair(LogicalType.TYPE, Boolean.FALSE);

    public final TypeValuePair evaluate(FormulaContext context, TypeValuePair value1, TypeValuePair value2) throws EvaluationException {
        TypeRegistry typeRegistry = context.getTypeRegistry();
        Type type1 = value1.getType();
        Type type2 = value2.getType();
        Object value1Raw = value1.getValue();
        Object value2Raw = value2.getValue();
        if (value1Raw == null || value2Raw == null) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_NA_VALUE);
        }
        ExtendedComparator comparator = typeRegistry.getComparator(type1, type2);
        Integer result = comparator.compare(type1, value1Raw, type2, value2Raw);
        if (result == null) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        if (this.evaluate(result)) {
            return RETURN_TRUE;
        }
        return RETURN_FALSE;
    }

    protected abstract boolean evaluate(int var1);
}

