/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.formula.function.text;

import org.jfree.formula.EvaluationException;
import org.jfree.formula.FormulaContext;
import org.jfree.formula.LibFormulaErrorValue;
import org.jfree.formula.function.Function;
import org.jfree.formula.function.ParameterCallback;
import org.jfree.formula.lvalues.TypeValuePair;
import org.jfree.formula.typing.Type;
import org.jfree.formula.typing.TypeRegistry;
import org.jfree.formula.typing.coretypes.TextType;

public class SubstituteFunction
implements Function {
    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        Object whichValue;
        int parameterCount = parameters.getParameterCount();
        if (parameterCount < 3 || parameterCount > 4) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = context.getTypeRegistry();
        Type newTextType = parameters.getType(2);
        Object newTextValue = parameters.getValue(2);
        Type textType = parameters.getType(0);
        Object textValue = parameters.getValue(0);
        Type oldTextType = parameters.getType(1);
        Object oldTextValue = parameters.getValue(1);
        String newText = typeRegistry.convertToText(newTextType, newTextValue);
        String text = typeRegistry.convertToText(textType, textValue);
        String oldText = typeRegistry.convertToText(oldTextType, oldTextValue);
        if (parameterCount == 3) {
            int index = text.indexOf(oldText);
            if (index == -1) {
                return new TypeValuePair(TextType.TYPE, text);
            }
            String result = text;
            while (index >= 0) {
                StringBuffer buffer = new StringBuffer(result);
                buffer.replace(index, index + oldText.length(), newText);
                result = buffer.toString();
                index = result.indexOf(oldText, index + newText.length());
            }
            return new TypeValuePair(TextType.TYPE, result);
        }
        Type whichType = parameters.getType(3);
        Number n = typeRegistry.convertToNumber(whichType, whichValue = parameters.getValue(3));
        if (n.doubleValue() < 1.0) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        int nthOccurence = n.intValue();
        int index = text.indexOf(oldText);
        if (index == -1) {
            return new TypeValuePair(TextType.TYPE, text);
        }
        String result = text;
        int counter = 1;
        while (index >= 0) {
            if (counter == nthOccurence) {
                StringBuffer buffer = new StringBuffer(result);
                buffer.replace(index, index + oldText.length(), newText);
                result = buffer.toString();
                index = result.indexOf(oldText, index + newText.length());
            } else {
                index = result.indexOf(oldText, index + 1);
            }
            ++counter;
        }
        return new TypeValuePair(TextType.TYPE, result);
    }

    public String getCanonicalName() {
        return "SUBSTITUTE";
    }
}

